package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;

public class QuoteRequestProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public QuoteRequestProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("QuoteRequest"));
  }

  public QuoteRequestProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public ReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> customerRef() {
     ReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("customerRef", projection);
     return projection;
  }

  public CustomerProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> customer() {
     CustomerProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new CustomerProjection<>(this, getRoot());
     getFields().put("customer", projection);
     return projection;
  }

  public ReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> customerGroupRef() {
     ReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("customerGroupRef", projection);
     return projection;
  }

  public CustomerGroupProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> customerGroup() {
     CustomerGroupProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new CustomerGroupProjection<>(this, getRoot());
     getFields().put("customerGroup", projection);
     return projection;
  }

  public LineItemProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> lineItems() {
     LineItemProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());
     getFields().put("lineItems", projection);
     return projection;
  }

  public LineItemProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> lineItems(String id) {
    LineItemProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new LineItemProjection<>(this, getRoot());    
    getFields().put("lineItems", projection);
    getInputArguments().computeIfAbsent("lineItems", k -> new ArrayList<>());                      
    InputArgument idArg = new InputArgument("id", id);
    getInputArguments().get("lineItems").add(idArg);
    return projection;
  }

  public CustomLineItemProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> customLineItems() {
     CustomLineItemProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new CustomLineItemProjection<>(this, getRoot());
     getFields().put("customLineItems", projection);
     return projection;
  }

  public MoneyProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> totalPrice() {
     MoneyProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new MoneyProjection<>(this, getRoot());
     getFields().put("totalPrice", projection);
     return projection;
  }

  public TaxedPriceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> taxedPrice() {
     TaxedPriceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new TaxedPriceProjection<>(this, getRoot());
     getFields().put("taxedPrice", projection);
     return projection;
  }

  public AddressProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> shippingAddress() {
     AddressProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("shippingAddress", projection);
     return projection;
  }

  public AddressProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> billingAddress() {
     AddressProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("billingAddress", projection);
     return projection;
  }

  public AddressProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> itemShippingAddresses() {
     AddressProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new AddressProjection<>(this, getRoot());
     getFields().put("itemShippingAddresses", projection);
     return projection;
  }

  public InventoryModeProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> inventoryMode() {
     InventoryModeProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new InventoryModeProjection<>(this, getRoot());
     getFields().put("inventoryMode", projection);
     return projection;
  }

  public TaxModeProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> taxMode() {
     TaxModeProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new TaxModeProjection<>(this, getRoot());
     getFields().put("taxMode", projection);
     return projection;
  }

  public RoundingModeProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> taxRoundingMode() {
     RoundingModeProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new RoundingModeProjection<>(this, getRoot());
     getFields().put("taxRoundingMode", projection);
     return projection;
  }

  public TaxCalculationModeProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> taxCalculationMode(
      ) {
     TaxCalculationModeProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new TaxCalculationModeProjection<>(this, getRoot());
     getFields().put("taxCalculationMode", projection);
     return projection;
  }

  public ShippingInfoProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> shippingInfo() {
     ShippingInfoProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new ShippingInfoProjection<>(this, getRoot());
     getFields().put("shippingInfo", projection);
     return projection;
  }

  public PaymentInfoProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> paymentInfo() {
     PaymentInfoProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new PaymentInfoProjection<>(this, getRoot());
     getFields().put("paymentInfo", projection);
     return projection;
  }

  public DirectDiscountProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> directDiscounts() {
     DirectDiscountProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new DirectDiscountProjection<>(this, getRoot());
     getFields().put("directDiscounts", projection);
     return projection;
  }

  public ShippingRateInputProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> shippingRateInput(
      ) {
     ShippingRateInputProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new ShippingRateInputProjection<>(this, getRoot());
     getFields().put("shippingRateInput", projection);
     return projection;
  }

  public KeyReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> storeRef() {
     KeyReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("storeRef", projection);
     return projection;
  }

  public StoreProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> store() {
     StoreProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new StoreProjection<>(this, getRoot());
     getFields().put("store", projection);
     return projection;
  }

  public BusinessUnitProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> businessUnit() {
     BusinessUnitProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new BusinessUnitProjection<>(this, getRoot());
     getFields().put("businessUnit", projection);
     return projection;
  }

  public KeyReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> businessUnitRef() {
     KeyReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new KeyReferenceProjection<>(this, getRoot());
     getFields().put("businessUnitRef", projection);
     return projection;
  }

  public QuoteRequestStateProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> quoteRequestState(
      ) {
     QuoteRequestStateProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new QuoteRequestStateProjection<>(this, getRoot());
     getFields().put("quoteRequestState", projection);
     return projection;
  }

  public CustomFieldsTypeProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> custom() {
     CustomFieldsTypeProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new CustomFieldsTypeProjection<>(this, getRoot());
     getFields().put("custom", projection);
     return projection;
  }

  public ReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> stateRef() {
     ReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("stateRef", projection);
     return projection;
  }

  public StateProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> state() {
     StateProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new StateProjection<>(this, getRoot());
     getFields().put("state", projection);
     return projection;
  }

  public ReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> cartRef() {
     ReferenceProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("cartRef", projection);
     return projection;
  }

  public InitiatorProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<QuoteRequestProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public QuoteRequestProjection<PARENT, ROOT> country() {
    getFields().put("country", null);
    return this;
  }

  public QuoteRequestProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public QuoteRequestProjection<PARENT, ROOT> comment() {
    getFields().put("comment", null);
    return this;
  }

  public QuoteRequestProjection<PARENT, ROOT> purchaseOrderNumber() {
    getFields().put("purchaseOrderNumber", null);
    return this;
  }

  public QuoteRequestProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public QuoteRequestProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public QuoteRequestProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public QuoteRequestProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
