package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ReferenceInput;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class ReplicateMyCartGraphQLQuery extends GraphQLQuery {
  public ReplicateMyCartGraphQLQuery(ReferenceInput reference, String queryName,
      Set<String> fieldsSet) {
    super("mutation", queryName);
    if (reference != null || fieldsSet.contains("reference")) {
        getInput().put("reference", reference);
    }
  }

  public ReplicateMyCartGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "replicateMyCart";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private ReferenceInput reference;

    private String queryName;

    public ReplicateMyCartGraphQLQuery build() {
      return new ReplicateMyCartGraphQLQuery(reference, queryName, fieldsSet);
               
    }

    public Builder reference(ReferenceInput reference) {
      this.reference = reference;
      this.fieldsSet.add("reference");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
