package com.commercetools.graphql.api.client;

import com.netflix.graphql.dgs.client.codegen.BaseSubProjectionNode;
import java.lang.String;
import java.util.ArrayList;
import java.util.List;

public class StateProjection<PARENT extends BaseSubProjectionNode<?, ?>, ROOT extends BaseSubProjectionNode<?, ?>> extends BaseSubProjectionNode<PARENT, ROOT> {
  public StateProjection(PARENT parent, ROOT root) {
    super(parent, root, java.util.Optional.of("State"));
  }

  public StateProjection<PARENT, ROOT> __typename() {
    getFields().put("__typename", null);
    return this;
  }

  public StateTypeProjection<StateProjection<PARENT, ROOT>, ROOT> type() {
     StateTypeProjection<StateProjection<PARENT, ROOT>, ROOT> projection = new StateTypeProjection<>(this, getRoot());
     getFields().put("type", projection);
     return projection;
  }

  public StateRoleProjection<StateProjection<PARENT, ROOT>, ROOT> roles() {
     StateRoleProjection<StateProjection<PARENT, ROOT>, ROOT> projection = new StateRoleProjection<>(this, getRoot());
     getFields().put("roles", projection);
     return projection;
  }

  public LocalizedStringProjection<StateProjection<PARENT, ROOT>, ROOT> nameAllLocales() {
     LocalizedStringProjection<StateProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("nameAllLocales", projection);
     return projection;
  }

  public LocalizedStringProjection<StateProjection<PARENT, ROOT>, ROOT> descriptionAllLocales() {
     LocalizedStringProjection<StateProjection<PARENT, ROOT>, ROOT> projection = new LocalizedStringProjection<>(this, getRoot());
     getFields().put("descriptionAllLocales", projection);
     return projection;
  }

  public ReferenceProjection<StateProjection<PARENT, ROOT>, ROOT> transitionsRef() {
     ReferenceProjection<StateProjection<PARENT, ROOT>, ROOT> projection = new ReferenceProjection<>(this, getRoot());
     getFields().put("transitionsRef", projection);
     return projection;
  }

  public StateProjection<StateProjection<PARENT, ROOT>, ROOT> transitions() {
     StateProjection<StateProjection<PARENT, ROOT>, ROOT> projection = new StateProjection<>(this, getRoot());
     getFields().put("transitions", projection);
     return projection;
  }

  public InitiatorProjection<StateProjection<PARENT, ROOT>, ROOT> createdBy() {
     InitiatorProjection<StateProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("createdBy", projection);
     return projection;
  }

  public InitiatorProjection<StateProjection<PARENT, ROOT>, ROOT> lastModifiedBy() {
     InitiatorProjection<StateProjection<PARENT, ROOT>, ROOT> projection = new InitiatorProjection<>(this, getRoot());
     getFields().put("lastModifiedBy", projection);
     return projection;
  }

  public StateProjection<PARENT, ROOT> id() {
    getFields().put("id", null);
    return this;
  }

  public StateProjection<PARENT, ROOT> version() {
    getFields().put("version", null);
    return this;
  }

  public StateProjection<PARENT, ROOT> key() {
    getFields().put("key", null);
    return this;
  }

  public StateProjection<PARENT, ROOT> name() {
    getFields().put("name", null);
    return this;
  }

  public StateProjection name(String locale, List<String> acceptLanguage) {
    getFields().put("name", null);
    getInputArguments().computeIfAbsent("name", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("name").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("name").add(acceptLanguageArg);
    return this;
  }

  public StateProjection<PARENT, ROOT> description() {
    getFields().put("description", null);
    return this;
  }

  public StateProjection description(String locale, List<String> acceptLanguage) {
    getFields().put("description", null);
    getInputArguments().computeIfAbsent("description", k -> new ArrayList<>());
    InputArgument localeArg = new InputArgument("locale", locale);
    getInputArguments().get("description").add(localeArg);
    InputArgument acceptLanguageArg = new InputArgument("acceptLanguage", acceptLanguage);
    getInputArguments().get("description").add(acceptLanguageArg);
    return this;
  }

  public StateProjection<PARENT, ROOT> builtIn() {
    getFields().put("builtIn", null);
    return this;
  }

  public StateProjection<PARENT, ROOT> initial() {
    getFields().put("initial", null);
    return this;
  }

  public StateProjection<PARENT, ROOT> createdAt() {
    getFields().put("createdAt", null);
    return this;
  }

  public StateProjection<PARENT, ROOT> lastModifiedAt() {
    getFields().put("lastModifiedAt", null);
    return this;
  }
}
