package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.ApprovalFlowUpdateAction;
import com.commercetools.graphql.api.types.AsAssociateArgument;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UpdateApprovalFlowGraphQLQuery extends GraphQLQuery {
  public UpdateApprovalFlowGraphQLQuery(Long version, List<ApprovalFlowUpdateAction> actions,
      AsAssociateArgument asAssociate, String id, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (actions != null || fieldsSet.contains("actions")) {
        getInput().put("actions", actions);
    }if (asAssociate != null || fieldsSet.contains("asAssociate")) {
        getInput().put("asAssociate", asAssociate);
    }if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }
  }

  public UpdateApprovalFlowGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "updateApprovalFlow";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Long version;

    private List<ApprovalFlowUpdateAction> actions;

    private AsAssociateArgument asAssociate;

    private String id;

    private String queryName;

    public UpdateApprovalFlowGraphQLQuery build() {
      return new UpdateApprovalFlowGraphQLQuery(version, actions, asAssociate, id, queryName, fieldsSet);
               
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder actions(List<ApprovalFlowUpdateAction> actions) {
      this.actions = actions;
      this.fieldsSet.add("actions");
      return this;
    }

    /**
     * Create/modify entity as an associate in business-unit.
     */
    public Builder asAssociate(AsAssociateArgument asAssociate) {
      this.asAssociate = asAssociate;
      this.fieldsSet.add("asAssociate");
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
