package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.MyCustomerUpdateAction;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class UpdateMyCustomerGraphQLQuery extends GraphQLQuery {
  public UpdateMyCustomerGraphQLQuery(Long version, List<MyCustomerUpdateAction> actions,
      String storeKey, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (actions != null || fieldsSet.contains("actions")) {
        getInput().put("actions", actions);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }
  }

  public UpdateMyCustomerGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "updateMyCustomer";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Long version;

    private List<MyCustomerUpdateAction> actions;

    private String storeKey;

    private String queryName;

    public UpdateMyCustomerGraphQLQuery build() {
      return new UpdateMyCustomerGraphQLQuery(version, actions, storeKey, queryName, fieldsSet);
               
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder actions(List<MyCustomerUpdateAction> actions) {
      this.actions = actions;
      this.fieldsSet.add("actions");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
