package com.commercetools.graphql.api.client;

import com.commercetools.graphql.api.types.StagedQuoteUpdateAction;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UpdateStagedQuoteGraphQLQuery extends GraphQLQuery {
  public UpdateStagedQuoteGraphQLQuery(Long version, List<StagedQuoteUpdateAction> actions,
      String storeKey, String id, String key, String queryName, Set<String> fieldsSet) {
    super("mutation", queryName);
    if (version != null || fieldsSet.contains("version")) {
        getInput().put("version", version);
    }if (actions != null || fieldsSet.contains("actions")) {
        getInput().put("actions", actions);
    }if (storeKey != null || fieldsSet.contains("storeKey")) {
        getInput().put("storeKey", storeKey);
    }if (id != null || fieldsSet.contains("id")) {
        getInput().put("id", id);
    }if (key != null || fieldsSet.contains("key")) {
        getInput().put("key", key);
    }
  }

  public UpdateStagedQuoteGraphQLQuery() {
    super("mutation");
  }

  @Override
  public String getOperationName() {
    return "updateStagedQuote";
  }

  public static Builder newRequest() {
    return new Builder();
  }

  public static class Builder {
    private Set<String> fieldsSet = new HashSet<>();

    private Long version;

    private List<StagedQuoteUpdateAction> actions;

    private String storeKey;

    private String id;

    private String key;

    private String queryName;

    public UpdateStagedQuoteGraphQLQuery build() {
      return new UpdateStagedQuoteGraphQLQuery(version, actions, storeKey, id, key, queryName, fieldsSet);
               
    }

    public Builder version(Long version) {
      this.version = version;
      this.fieldsSet.add("version");
      return this;
    }

    public Builder actions(List<StagedQuoteUpdateAction> actions) {
      this.actions = actions;
      this.fieldsSet.add("actions");
      return this;
    }

    /**
     * The mutation is only performed if the resource is part of the store. Can be used with store-specific OAuth permissions.
     */
    public Builder storeKey(String storeKey) {
      this.storeKey = storeKey;
      this.fieldsSet.add("storeKey");
      return this;
    }

    /**
     * Queries with specified ID
     */
    public Builder id(String id) {
      this.id = id;
      this.fieldsSet.add("id");
      return this;
    }

    /**
     * Queries with specified key
     */
    public Builder key(String key) {
      this.key = key;
      this.fieldsSet.add("key");
      return this;
    }

    public Builder queryName(String queryName) {
      this.queryName = queryName;
      return this;
    }
  }
}
