package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;

/**
 * API Clients can be used to obtain OAuth 2 access tokens
 */
public class APIClientWithoutSecret {
  private String id;

  private String name;

  private String scope;

  private OffsetDateTime createdAt;

  private LocalDate lastUsedAt;

  private OffsetDateTime deleteAt;

  private Integer accessTokenValiditySeconds;

  private Integer refreshTokenValiditySeconds;

  public APIClientWithoutSecret() {
  }

  public APIClientWithoutSecret(String id, String name, String scope, OffsetDateTime createdAt,
      LocalDate lastUsedAt, OffsetDateTime deleteAt, Integer accessTokenValiditySeconds,
      Integer refreshTokenValiditySeconds) {
    this.id = id;
    this.name = name;
    this.scope = scope;
    this.createdAt = createdAt;
    this.lastUsedAt = lastUsedAt;
    this.deleteAt = deleteAt;
    this.accessTokenValiditySeconds = accessTokenValiditySeconds;
    this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getScope() {
    return scope;
  }

  public void setScope(String scope) {
    this.scope = scope;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public LocalDate getLastUsedAt() {
    return lastUsedAt;
  }

  public void setLastUsedAt(LocalDate lastUsedAt) {
    this.lastUsedAt = lastUsedAt;
  }

  public OffsetDateTime getDeleteAt() {
    return deleteAt;
  }

  public void setDeleteAt(OffsetDateTime deleteAt) {
    this.deleteAt = deleteAt;
  }

  public Integer getAccessTokenValiditySeconds() {
    return accessTokenValiditySeconds;
  }

  public void setAccessTokenValiditySeconds(Integer accessTokenValiditySeconds) {
    this.accessTokenValiditySeconds = accessTokenValiditySeconds;
  }

  public Integer getRefreshTokenValiditySeconds() {
    return refreshTokenValiditySeconds;
  }

  public void setRefreshTokenValiditySeconds(Integer refreshTokenValiditySeconds) {
    this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
  }

  @Override
  public String toString() {
    return "APIClientWithoutSecret{id='" + id + "', name='" + name + "', scope='" + scope + "', createdAt='" + createdAt + "', lastUsedAt='" + lastUsedAt + "', deleteAt='" + deleteAt + "', accessTokenValiditySeconds='" + accessTokenValiditySeconds + "', refreshTokenValiditySeconds='" + refreshTokenValiditySeconds + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    APIClientWithoutSecret that = (APIClientWithoutSecret) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(name, that.name) &&
        Objects.equals(scope, that.scope) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastUsedAt, that.lastUsedAt) &&
        Objects.equals(deleteAt, that.deleteAt) &&
        Objects.equals(accessTokenValiditySeconds, that.accessTokenValiditySeconds) &&
        Objects.equals(refreshTokenValiditySeconds, that.refreshTokenValiditySeconds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, scope, createdAt, lastUsedAt, deleteAt, accessTokenValiditySeconds, refreshTokenValiditySeconds);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private String name;

    private String scope;

    private OffsetDateTime createdAt;

    private LocalDate lastUsedAt;

    private OffsetDateTime deleteAt;

    private Integer accessTokenValiditySeconds;

    private Integer refreshTokenValiditySeconds;

    public APIClientWithoutSecret build() {
      APIClientWithoutSecret result = new APIClientWithoutSecret();
      result.id = this.id;
      result.name = this.name;
      result.scope = this.scope;
      result.createdAt = this.createdAt;
      result.lastUsedAt = this.lastUsedAt;
      result.deleteAt = this.deleteAt;
      result.accessTokenValiditySeconds = this.accessTokenValiditySeconds;
      result.refreshTokenValiditySeconds = this.refreshTokenValiditySeconds;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder scope(String scope) {
      this.scope = scope;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastUsedAt(LocalDate lastUsedAt) {
      this.lastUsedAt = lastUsedAt;
      return this;
    }

    public Builder deleteAt(OffsetDateTime deleteAt) {
      this.deleteAt = deleteAt;
      return this;
    }

    public Builder accessTokenValiditySeconds(Integer accessTokenValiditySeconds) {
      this.accessTokenValiditySeconds = accessTokenValiditySeconds;
      return this;
    }

    public Builder refreshTokenValiditySeconds(Integer refreshTokenValiditySeconds) {
      this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
      return this;
    }
  }
}
