package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AWSLambdaDestinationInput {
  private String arn;

  private String accessKey;

  private String accessSecret;

  public AWSLambdaDestinationInput() {
  }

  public AWSLambdaDestinationInput(String arn, String accessKey, String accessSecret) {
    this.arn = arn;
    this.accessKey = accessKey;
    this.accessSecret = accessSecret;
  }

  public String getArn() {
    return arn;
  }

  public void setArn(String arn) {
    this.arn = arn;
  }

  public String getAccessKey() {
    return accessKey;
  }

  public void setAccessKey(String accessKey) {
    this.accessKey = accessKey;
  }

  public String getAccessSecret() {
    return accessSecret;
  }

  public void setAccessSecret(String accessSecret) {
    this.accessSecret = accessSecret;
  }

  @Override
  public String toString() {
    return "AWSLambdaDestinationInput{arn='" + arn + "', accessKey='" + accessKey + "', accessSecret='" + accessSecret + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AWSLambdaDestinationInput that = (AWSLambdaDestinationInput) o;
    return Objects.equals(arn, that.arn) &&
        Objects.equals(accessKey, that.accessKey) &&
        Objects.equals(accessSecret, that.accessSecret);
  }

  @Override
  public int hashCode() {
    return Objects.hash(arn, accessKey, accessSecret);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String arn;

    private String accessKey;

    private String accessSecret;

    public AWSLambdaDestinationInput build() {
      AWSLambdaDestinationInput result = new AWSLambdaDestinationInput();
      result.arn = this.arn;
      result.accessKey = this.accessKey;
      result.accessSecret = this.accessSecret;
      return result;
    }

    public Builder arn(String arn) {
      this.arn = arn;
      return this;
    }

    public Builder accessKey(String accessKey) {
      this.accessKey = accessKey;
      return this;
    }

    public Builder accessSecret(String accessSecret) {
      this.accessSecret = accessSecret;
      return this;
    }
  }
}
