package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AbsoluteCartDiscountValue implements com.commercetools.graphql.api.types.CartDiscountValue {
  private List<Money> money;

  private DiscountApplicationMode applicationMode;

  private String type;

  public AbsoluteCartDiscountValue() {
  }

  public AbsoluteCartDiscountValue(List<Money> money, DiscountApplicationMode applicationMode,
      String type) {
    this.money = money;
    this.applicationMode = applicationMode;
    this.type = type;
  }

  public List<Money> getMoney() {
    return money;
  }

  public void setMoney(List<Money> money) {
    this.money = money;
  }

  public DiscountApplicationMode getApplicationMode() {
    return applicationMode;
  }

  public void setApplicationMode(DiscountApplicationMode applicationMode) {
    this.applicationMode = applicationMode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AbsoluteCartDiscountValue{money='" + money + "', applicationMode='" + applicationMode + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AbsoluteCartDiscountValue that = (AbsoluteCartDiscountValue) o;
    return Objects.equals(money, that.money) &&
        Objects.equals(applicationMode, that.applicationMode) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(money, applicationMode, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Money> money;

    private DiscountApplicationMode applicationMode;

    private String type;

    public AbsoluteCartDiscountValue build() {
      AbsoluteCartDiscountValue result = new AbsoluteCartDiscountValue();
      result.money = this.money;
      result.applicationMode = this.applicationMode;
      result.type = this.type;
      return result;
    }

    public Builder money(List<Money> money) {
      this.money = money;
      return this;
    }

    public Builder applicationMode(DiscountApplicationMode applicationMode) {
      this.applicationMode = applicationMode;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
