package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class AbsoluteDiscountValueInput {
  private List<MoneyInput> money;

  public AbsoluteDiscountValueInput() {
  }

  public AbsoluteDiscountValueInput(List<MoneyInput> money) {
    this.money = money;
  }

  public List<MoneyInput> getMoney() {
    return money;
  }

  public void setMoney(List<MoneyInput> money) {
    this.money = money;
  }

  @Override
  public String toString() {
    return "AbsoluteDiscountValueInput{money='" + money + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AbsoluteDiscountValueInput that = (AbsoluteDiscountValueInput) o;
    return Objects.equals(money, that.money);
  }

  @Override
  public int hashCode() {
    return Objects.hash(money);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<MoneyInput> money;

    public AbsoluteDiscountValueInput build() {
      AbsoluteDiscountValueInput result = new AbsoluteDiscountValueInput();
      result.money = this.money;
      return result;
    }

    public Builder money(List<MoneyInput> money) {
      this.money = money;
      return this;
    }
  }
}
