package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddAssociateRolePermission {
  private Permission permission;

  public AddAssociateRolePermission() {
  }

  public AddAssociateRolePermission(Permission permission) {
    this.permission = permission;
  }

  public Permission getPermission() {
    return permission;
  }

  public void setPermission(Permission permission) {
    this.permission = permission;
  }

  @Override
  public String toString() {
    return "AddAssociateRolePermission{permission='" + permission + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddAssociateRolePermission that = (AddAssociateRolePermission) o;
    return Objects.equals(permission, that.permission);
  }

  @Override
  public int hashCode() {
    return Objects.hash(permission);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Permission permission;

    public AddAssociateRolePermission build() {
      AddAssociateRolePermission result = new AddAssociateRolePermission();
      result.permission = this.permission;
      return result;
    }

    public Builder permission(Permission permission) {
      this.permission = permission;
      return this;
    }
  }
}
