package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AddCartCustomShippingMethod {
  private String shippingKey;

  private String shippingMethodName;

  private AddressInput shippingAddress;

  private ShippingRateDraft shippingRate;

  private ShippingRateInputDraft shippingRateInput;

  private ResourceIdentifierInput taxCategory;

  private ExternalTaxRateDraft externalTaxRate;

  private CustomFieldsDraft custom;

  private List<DeliveryDraft> deliveries = Collections.emptyList();

  public AddCartCustomShippingMethod() {
  }

  public AddCartCustomShippingMethod(String shippingKey, String shippingMethodName,
      AddressInput shippingAddress, ShippingRateDraft shippingRate,
      ShippingRateInputDraft shippingRateInput, ResourceIdentifierInput taxCategory,
      ExternalTaxRateDraft externalTaxRate, CustomFieldsDraft custom,
      List<DeliveryDraft> deliveries) {
    this.shippingKey = shippingKey;
    this.shippingMethodName = shippingMethodName;
    this.shippingAddress = shippingAddress;
    this.shippingRate = shippingRate;
    this.shippingRateInput = shippingRateInput;
    this.taxCategory = taxCategory;
    this.externalTaxRate = externalTaxRate;
    this.custom = custom;
    this.deliveries = deliveries;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getShippingMethodName() {
    return shippingMethodName;
  }

  public void setShippingMethodName(String shippingMethodName) {
    this.shippingMethodName = shippingMethodName;
  }

  public AddressInput getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(AddressInput shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public ShippingRateDraft getShippingRate() {
    return shippingRate;
  }

  public void setShippingRate(ShippingRateDraft shippingRate) {
    this.shippingRate = shippingRate;
  }

  public ShippingRateInputDraft getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInputDraft shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  public ResourceIdentifierInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public List<DeliveryDraft> getDeliveries() {
    return deliveries;
  }

  public void setDeliveries(List<DeliveryDraft> deliveries) {
    this.deliveries = deliveries;
  }

  @Override
  public String toString() {
    return "AddCartCustomShippingMethod{shippingKey='" + shippingKey + "', shippingMethodName='" + shippingMethodName + "', shippingAddress='" + shippingAddress + "', shippingRate='" + shippingRate + "', shippingRateInput='" + shippingRateInput + "', taxCategory='" + taxCategory + "', externalTaxRate='" + externalTaxRate + "', custom='" + custom + "', deliveries='" + deliveries + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddCartCustomShippingMethod that = (AddCartCustomShippingMethod) o;
    return Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(shippingMethodName, that.shippingMethodName) &&
        Objects.equals(shippingAddress, that.shippingAddress) &&
        Objects.equals(shippingRate, that.shippingRate) &&
        Objects.equals(shippingRateInput, that.shippingRateInput) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(deliveries, that.deliveries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingKey, shippingMethodName, shippingAddress, shippingRate, shippingRateInput, taxCategory, externalTaxRate, custom, deliveries);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String shippingKey;

    private String shippingMethodName;

    private AddressInput shippingAddress;

    private ShippingRateDraft shippingRate;

    private ShippingRateInputDraft shippingRateInput;

    private ResourceIdentifierInput taxCategory;

    private ExternalTaxRateDraft externalTaxRate;

    private CustomFieldsDraft custom;

    private List<DeliveryDraft> deliveries = Collections.emptyList();

    public AddCartCustomShippingMethod build() {
      AddCartCustomShippingMethod result = new AddCartCustomShippingMethod();
      result.shippingKey = this.shippingKey;
      result.shippingMethodName = this.shippingMethodName;
      result.shippingAddress = this.shippingAddress;
      result.shippingRate = this.shippingRate;
      result.shippingRateInput = this.shippingRateInput;
      result.taxCategory = this.taxCategory;
      result.externalTaxRate = this.externalTaxRate;
      result.custom = this.custom;
      result.deliveries = this.deliveries;
      return result;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder shippingMethodName(String shippingMethodName) {
      this.shippingMethodName = shippingMethodName;
      return this;
    }

    public Builder shippingAddress(AddressInput shippingAddress) {
      this.shippingAddress = shippingAddress;
      return this;
    }

    public Builder shippingRate(ShippingRateDraft shippingRate) {
      this.shippingRate = shippingRate;
      return this;
    }

    public Builder shippingRateInput(ShippingRateInputDraft shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }

    public Builder taxCategory(ResourceIdentifierInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder deliveries(List<DeliveryDraft> deliveries) {
      this.deliveries = deliveries;
      return this;
    }
  }
}
