package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AddCartShippingMethod {
  private String shippingKey;

  private ResourceIdentifierInput shippingMethod;

  private ExternalTaxRateDraft externalTaxRate;

  private AddressInput shippingAddress;

  private ShippingRateInputDraft shippingRateInput;

  private CustomFieldsDraft custom;

  private List<DeliveryDraft> deliveries = Collections.emptyList();

  public AddCartShippingMethod() {
  }

  public AddCartShippingMethod(String shippingKey, ResourceIdentifierInput shippingMethod,
      ExternalTaxRateDraft externalTaxRate, AddressInput shippingAddress,
      ShippingRateInputDraft shippingRateInput, CustomFieldsDraft custom,
      List<DeliveryDraft> deliveries) {
    this.shippingKey = shippingKey;
    this.shippingMethod = shippingMethod;
    this.externalTaxRate = externalTaxRate;
    this.shippingAddress = shippingAddress;
    this.shippingRateInput = shippingRateInput;
    this.custom = custom;
    this.deliveries = deliveries;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public ResourceIdentifierInput getShippingMethod() {
    return shippingMethod;
  }

  public void setShippingMethod(ResourceIdentifierInput shippingMethod) {
    this.shippingMethod = shippingMethod;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public AddressInput getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(AddressInput shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public ShippingRateInputDraft getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInputDraft shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public List<DeliveryDraft> getDeliveries() {
    return deliveries;
  }

  public void setDeliveries(List<DeliveryDraft> deliveries) {
    this.deliveries = deliveries;
  }

  @Override
  public String toString() {
    return "AddCartShippingMethod{shippingKey='" + shippingKey + "', shippingMethod='" + shippingMethod + "', externalTaxRate='" + externalTaxRate + "', shippingAddress='" + shippingAddress + "', shippingRateInput='" + shippingRateInput + "', custom='" + custom + "', deliveries='" + deliveries + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddCartShippingMethod that = (AddCartShippingMethod) o;
    return Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(shippingMethod, that.shippingMethod) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(shippingAddress, that.shippingAddress) &&
        Objects.equals(shippingRateInput, that.shippingRateInput) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(deliveries, that.deliveries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingKey, shippingMethod, externalTaxRate, shippingAddress, shippingRateInput, custom, deliveries);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String shippingKey;

    private ResourceIdentifierInput shippingMethod;

    private ExternalTaxRateDraft externalTaxRate;

    private AddressInput shippingAddress;

    private ShippingRateInputDraft shippingRateInput;

    private CustomFieldsDraft custom;

    private List<DeliveryDraft> deliveries = Collections.emptyList();

    public AddCartShippingMethod build() {
      AddCartShippingMethod result = new AddCartShippingMethod();
      result.shippingKey = this.shippingKey;
      result.shippingMethod = this.shippingMethod;
      result.externalTaxRate = this.externalTaxRate;
      result.shippingAddress = this.shippingAddress;
      result.shippingRateInput = this.shippingRateInput;
      result.custom = this.custom;
      result.deliveries = this.deliveries;
      return result;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder shippingMethod(ResourceIdentifierInput shippingMethod) {
      this.shippingMethod = shippingMethod;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder shippingAddress(AddressInput shippingAddress) {
      this.shippingAddress = shippingAddress;
      return this;
    }

    public Builder shippingRateInput(ShippingRateInputDraft shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder deliveries(List<DeliveryDraft> deliveries) {
      this.deliveries = deliveries;
      return this;
    }
  }
}
