package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class AddCustomerGroupAssignment {
  private CustomerGroupAssignmentDraft customerGroupAssignment;

  public AddCustomerGroupAssignment() {
  }

  public AddCustomerGroupAssignment(CustomerGroupAssignmentDraft customerGroupAssignment) {
    this.customerGroupAssignment = customerGroupAssignment;
  }

  public CustomerGroupAssignmentDraft getCustomerGroupAssignment() {
    return customerGroupAssignment;
  }

  public void setCustomerGroupAssignment(CustomerGroupAssignmentDraft customerGroupAssignment) {
    this.customerGroupAssignment = customerGroupAssignment;
  }

  @Override
  public String toString() {
    return "AddCustomerGroupAssignment{customerGroupAssignment='" + customerGroupAssignment + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddCustomerGroupAssignment that = (AddCustomerGroupAssignment) o;
    return Objects.equals(customerGroupAssignment, that.customerGroupAssignment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerGroupAssignment);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomerGroupAssignmentDraft customerGroupAssignment;

    public AddCustomerGroupAssignment build() {
      AddCustomerGroupAssignment result = new AddCustomerGroupAssignment();
      result.customerGroupAssignment = this.customerGroupAssignment;
      return result;
    }

    public Builder customerGroupAssignment(CustomerGroupAssignmentDraft customerGroupAssignment) {
      this.customerGroupAssignment = customerGroupAssignment;
      return this;
    }
  }
}
