package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddMyPaymentTransaction {
  private MyTransactionDraft transaction;

  public AddMyPaymentTransaction() {
  }

  public AddMyPaymentTransaction(MyTransactionDraft transaction) {
    this.transaction = transaction;
  }

  public MyTransactionDraft getTransaction() {
    return transaction;
  }

  public void setTransaction(MyTransactionDraft transaction) {
    this.transaction = transaction;
  }

  @Override
  public String toString() {
    return "AddMyPaymentTransaction{transaction='" + transaction + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddMyPaymentTransaction that = (AddMyPaymentTransaction) o;
    return Objects.equals(transaction, that.transaction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transaction);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MyTransactionDraft transaction;

    public AddMyPaymentTransaction build() {
      AddMyPaymentTransaction result = new AddMyPaymentTransaction();
      result.transaction = this.transaction;
      return result;
    }

    public Builder transaction(MyTransactionDraft transaction) {
      this.transaction = transaction;
      return this;
    }
  }
}
