package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddProductAsset {
  private Integer variantId;

  private String sku;

  private Boolean staged = true;

  private Integer position;

  private AssetDraftInput asset;

  public AddProductAsset() {
  }

  public AddProductAsset(Integer variantId, String sku, Boolean staged, Integer position,
      AssetDraftInput asset) {
    this.variantId = variantId;
    this.sku = sku;
    this.staged = staged;
    this.position = position;
    this.asset = asset;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public Integer getPosition() {
    return position;
  }

  public void setPosition(Integer position) {
    this.position = position;
  }

  public AssetDraftInput getAsset() {
    return asset;
  }

  public void setAsset(AssetDraftInput asset) {
    this.asset = asset;
  }

  @Override
  public String toString() {
    return "AddProductAsset{variantId='" + variantId + "', sku='" + sku + "', staged='" + staged + "', position='" + position + "', asset='" + asset + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddProductAsset that = (AddProductAsset) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(position, that.position) &&
        Objects.equals(asset, that.asset);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, staged, position, asset);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private Boolean staged = true;

    private Integer position;

    private AssetDraftInput asset;

    public AddProductAsset build() {
      AddProductAsset result = new AddProductAsset();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.staged = this.staged;
      result.position = this.position;
      result.asset = this.asset;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder position(Integer position) {
      this.position = position;
      return this;
    }

    public Builder asset(AssetDraftInput asset) {
      this.asset = asset;
      return this;
    }
  }
}
