package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddProductExternalImage {
  private Integer variantId;

  private String sku;

  private ImageInput image;

  private Boolean staged = true;

  public AddProductExternalImage() {
  }

  public AddProductExternalImage(Integer variantId, String sku, ImageInput image, Boolean staged) {
    this.variantId = variantId;
    this.sku = sku;
    this.image = image;
    this.staged = staged;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public ImageInput getImage() {
    return image;
  }

  public void setImage(ImageInput image) {
    this.image = image;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "AddProductExternalImage{variantId='" + variantId + "', sku='" + sku + "', image='" + image + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddProductExternalImage that = (AddProductExternalImage) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(image, that.image) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, image, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private ImageInput image;

    private Boolean staged = true;

    public AddProductExternalImage build() {
      AddProductExternalImage result = new AddProductExternalImage();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.image = this.image;
      result.staged = this.staged;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder image(ImageInput image) {
      this.image = image;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
