package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddProductToCategory {
  private ResourceIdentifierInput category;

  private String orderHint;

  private Boolean staged = true;

  public AddProductToCategory() {
  }

  public AddProductToCategory(ResourceIdentifierInput category, String orderHint, Boolean staged) {
    this.category = category;
    this.orderHint = orderHint;
    this.staged = staged;
  }

  public ResourceIdentifierInput getCategory() {
    return category;
  }

  public void setCategory(ResourceIdentifierInput category) {
    this.category = category;
  }

  public String getOrderHint() {
    return orderHint;
  }

  public void setOrderHint(String orderHint) {
    this.orderHint = orderHint;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "AddProductToCategory{category='" + category + "', orderHint='" + orderHint + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddProductToCategory that = (AddProductToCategory) o;
    return Objects.equals(category, that.category) &&
        Objects.equals(orderHint, that.orderHint) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(category, orderHint, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput category;

    private String orderHint;

    private Boolean staged = true;

    public AddProductToCategory build() {
      AddProductToCategory result = new AddProductToCategory();
      result.category = this.category;
      result.orderHint = this.orderHint;
      result.staged = this.staged;
      return result;
    }

    public Builder category(ResourceIdentifierInput category) {
      this.category = category;
      return this;
    }

    public Builder orderHint(String orderHint) {
      this.orderHint = orderHint;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
