package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AddProductVariant {
  private List<AssetDraftInput> assets = Collections.emptyList();

  private List<ProductAttributeInput> attributes = Collections.emptyList();

  private List<ImageInput> images = Collections.emptyList();

  private List<ProductPriceDataInput> prices = Collections.emptyList();

  private String key;

  private String sku;

  private Boolean staged = true;

  public AddProductVariant() {
  }

  public AddProductVariant(List<AssetDraftInput> assets, List<ProductAttributeInput> attributes,
      List<ImageInput> images, List<ProductPriceDataInput> prices, String key, String sku,
      Boolean staged) {
    this.assets = assets;
    this.attributes = attributes;
    this.images = images;
    this.prices = prices;
    this.key = key;
    this.sku = sku;
    this.staged = staged;
  }

  public List<AssetDraftInput> getAssets() {
    return assets;
  }

  public void setAssets(List<AssetDraftInput> assets) {
    this.assets = assets;
  }

  public List<ProductAttributeInput> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<ProductAttributeInput> attributes) {
    this.attributes = attributes;
  }

  public List<ImageInput> getImages() {
    return images;
  }

  public void setImages(List<ImageInput> images) {
    this.images = images;
  }

  public List<ProductPriceDataInput> getPrices() {
    return prices;
  }

  public void setPrices(List<ProductPriceDataInput> prices) {
    this.prices = prices;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "AddProductVariant{assets='" + assets + "', attributes='" + attributes + "', images='" + images + "', prices='" + prices + "', key='" + key + "', sku='" + sku + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddProductVariant that = (AddProductVariant) o;
    return Objects.equals(assets, that.assets) &&
        Objects.equals(attributes, that.attributes) &&
        Objects.equals(images, that.images) &&
        Objects.equals(prices, that.prices) &&
        Objects.equals(key, that.key) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assets, attributes, images, prices, key, sku, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<AssetDraftInput> assets = Collections.emptyList();

    private List<ProductAttributeInput> attributes = Collections.emptyList();

    private List<ImageInput> images = Collections.emptyList();

    private List<ProductPriceDataInput> prices = Collections.emptyList();

    private String key;

    private String sku;

    private Boolean staged = true;

    public AddProductVariant build() {
      AddProductVariant result = new AddProductVariant();
      result.assets = this.assets;
      result.attributes = this.attributes;
      result.images = this.images;
      result.prices = this.prices;
      result.key = this.key;
      result.sku = this.sku;
      result.staged = this.staged;
      return result;
    }

    public Builder assets(List<AssetDraftInput> assets) {
      this.assets = assets;
      return this;
    }

    public Builder attributes(List<ProductAttributeInput> attributes) {
      this.attributes = attributes;
      return this;
    }

    public Builder images(List<ImageInput> images) {
      this.images = images;
      return this;
    }

    public Builder prices(List<ProductPriceDataInput> prices) {
      this.prices = prices;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
