package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddShippingMethodZone {
  private ResourceIdentifierInput zone;

  public AddShippingMethodZone() {
  }

  public AddShippingMethodZone(ResourceIdentifierInput zone) {
    this.zone = zone;
  }

  public ResourceIdentifierInput getZone() {
    return zone;
  }

  public void setZone(ResourceIdentifierInput zone) {
    this.zone = zone;
  }

  @Override
  public String toString() {
    return "AddShippingMethodZone{zone='" + zone + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddShippingMethodZone that = (AddShippingMethodZone) o;
    return Objects.equals(zone, that.zone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(zone);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput zone;

    public AddShippingMethodZone build() {
      AddShippingMethodZone result = new AddShippingMethodZone();
      result.zone = this.zone;
      return result;
    }

    public Builder zone(ResourceIdentifierInput zone) {
      this.zone = zone;
      return this;
    }
  }
}
