package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AddStagedOrderDelivery {
  private String deliveryKey;

  private List<DeliveryItemDraftType> items = Collections.emptyList();

  private List<ParcelDataDraftType> parcels = Collections.emptyList();

  private AddressInput address;

  private CustomFieldsDraft custom;

  private String shippingKey;

  public AddStagedOrderDelivery() {
  }

  public AddStagedOrderDelivery(String deliveryKey, List<DeliveryItemDraftType> items,
      List<ParcelDataDraftType> parcels, AddressInput address, CustomFieldsDraft custom,
      String shippingKey) {
    this.deliveryKey = deliveryKey;
    this.items = items;
    this.parcels = parcels;
    this.address = address;
    this.custom = custom;
    this.shippingKey = shippingKey;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  public List<DeliveryItemDraftType> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItemDraftType> items) {
    this.items = items;
  }

  public List<ParcelDataDraftType> getParcels() {
    return parcels;
  }

  public void setParcels(List<ParcelDataDraftType> parcels) {
    this.parcels = parcels;
  }

  public AddressInput getAddress() {
    return address;
  }

  public void setAddress(AddressInput address) {
    this.address = address;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  @Override
  public String toString() {
    return "AddStagedOrderDelivery{deliveryKey='" + deliveryKey + "', items='" + items + "', parcels='" + parcels + "', address='" + address + "', custom='" + custom + "', shippingKey='" + shippingKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderDelivery that = (AddStagedOrderDelivery) o;
    return Objects.equals(deliveryKey, that.deliveryKey) &&
        Objects.equals(items, that.items) &&
        Objects.equals(parcels, that.parcels) &&
        Objects.equals(address, that.address) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(shippingKey, that.shippingKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deliveryKey, items, parcels, address, custom, shippingKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String deliveryKey;

    private List<DeliveryItemDraftType> items = Collections.emptyList();

    private List<ParcelDataDraftType> parcels = Collections.emptyList();

    private AddressInput address;

    private CustomFieldsDraft custom;

    private String shippingKey;

    public AddStagedOrderDelivery build() {
      AddStagedOrderDelivery result = new AddStagedOrderDelivery();
      result.deliveryKey = this.deliveryKey;
      result.items = this.items;
      result.parcels = this.parcels;
      result.address = this.address;
      result.custom = this.custom;
      result.shippingKey = this.shippingKey;
      return result;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }

    public Builder items(List<DeliveryItemDraftType> items) {
      this.items = items;
      return this;
    }

    public Builder parcels(List<ParcelDataDraftType> parcels) {
      this.parcels = parcels;
      return this;
    }

    public Builder address(AddressInput address) {
      this.address = address;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }
  }
}
