package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddStagedOrderDiscountCode {
  private String code;

  private Boolean validateDuplicates = false;

  public AddStagedOrderDiscountCode() {
  }

  public AddStagedOrderDiscountCode(String code, Boolean validateDuplicates) {
    this.code = code;
    this.validateDuplicates = validateDuplicates;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public Boolean getValidateDuplicates() {
    return validateDuplicates;
  }

  public void setValidateDuplicates(Boolean validateDuplicates) {
    this.validateDuplicates = validateDuplicates;
  }

  @Override
  public String toString() {
    return "AddStagedOrderDiscountCode{code='" + code + "', validateDuplicates='" + validateDuplicates + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderDiscountCode that = (AddStagedOrderDiscountCode) o;
    return Objects.equals(code, that.code) &&
        Objects.equals(validateDuplicates, that.validateDuplicates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, validateDuplicates);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String code;

    private Boolean validateDuplicates = false;

    public AddStagedOrderDiscountCode build() {
      AddStagedOrderDiscountCode result = new AddStagedOrderDiscountCode();
      result.code = this.code;
      result.validateDuplicates = this.validateDuplicates;
      return result;
    }

    public Builder code(String code) {
      this.code = code;
      return this;
    }

    public Builder validateDuplicates(Boolean validateDuplicates) {
      this.validateDuplicates = validateDuplicates;
      return this;
    }
  }
}
