package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AddStagedOrderDiscountCodeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String code;

  private Boolean validateDuplicates;

  public AddStagedOrderDiscountCodeOutput() {
  }

  public AddStagedOrderDiscountCodeOutput(String type, String code, Boolean validateDuplicates) {
    this.type = type;
    this.code = code;
    this.validateDuplicates = validateDuplicates;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public Boolean getValidateDuplicates() {
    return validateDuplicates;
  }

  public void setValidateDuplicates(Boolean validateDuplicates) {
    this.validateDuplicates = validateDuplicates;
  }

  @Override
  public String toString() {
    return "AddStagedOrderDiscountCodeOutput{type='" + type + "', code='" + code + "', validateDuplicates='" + validateDuplicates + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderDiscountCodeOutput that = (AddStagedOrderDiscountCodeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(code, that.code) &&
        Objects.equals(validateDuplicates, that.validateDuplicates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, code, validateDuplicates);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String code;

    private Boolean validateDuplicates;

    public AddStagedOrderDiscountCodeOutput build() {
      AddStagedOrderDiscountCodeOutput result = new AddStagedOrderDiscountCodeOutput();
      result.type = this.type;
      result.code = this.code;
      result.validateDuplicates = this.validateDuplicates;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder code(String code) {
      this.code = code;
      return this;
    }

    public Builder validateDuplicates(Boolean validateDuplicates) {
      this.validateDuplicates = validateDuplicates;
      return this;
    }
  }
}
