package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AddStagedOrderLineItem {
  private OffsetDateTime addedAt;

  private ItemShippingDetailsDraftType shippingDetails;

  private InventoryMode inventoryMode;

  private ExternalLineItemTotalPriceDraft externalTotalPrice;

  private BaseMoneyInput externalPrice;

  private List<MethodExternalTaxRateDraft> perMethodExternalTaxRate = Collections.emptyList();

  private ExternalTaxRateDraft externalTaxRate;

  private CustomFieldsDraft custom;

  private ResourceIdentifierInput distributionChannel;

  private ResourceIdentifierInput supplyChannel;

  private Integer variantId;

  private Long quantity;

  private String key;

  private String sku;

  private String productId;

  public AddStagedOrderLineItem() {
  }

  public AddStagedOrderLineItem(OffsetDateTime addedAt,
      ItemShippingDetailsDraftType shippingDetails, InventoryMode inventoryMode,
      ExternalLineItemTotalPriceDraft externalTotalPrice, BaseMoneyInput externalPrice,
      List<MethodExternalTaxRateDraft> perMethodExternalTaxRate,
      ExternalTaxRateDraft externalTaxRate, CustomFieldsDraft custom,
      ResourceIdentifierInput distributionChannel, ResourceIdentifierInput supplyChannel,
      Integer variantId, Long quantity, String key, String sku, String productId) {
    this.addedAt = addedAt;
    this.shippingDetails = shippingDetails;
    this.inventoryMode = inventoryMode;
    this.externalTotalPrice = externalTotalPrice;
    this.externalPrice = externalPrice;
    this.perMethodExternalTaxRate = perMethodExternalTaxRate;
    this.externalTaxRate = externalTaxRate;
    this.custom = custom;
    this.distributionChannel = distributionChannel;
    this.supplyChannel = supplyChannel;
    this.variantId = variantId;
    this.quantity = quantity;
    this.key = key;
    this.sku = sku;
    this.productId = productId;
  }

  public OffsetDateTime getAddedAt() {
    return addedAt;
  }

  public void setAddedAt(OffsetDateTime addedAt) {
    this.addedAt = addedAt;
  }

  public ItemShippingDetailsDraftType getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraftType shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  public InventoryMode getInventoryMode() {
    return inventoryMode;
  }

  public void setInventoryMode(InventoryMode inventoryMode) {
    this.inventoryMode = inventoryMode;
  }

  public ExternalLineItemTotalPriceDraft getExternalTotalPrice() {
    return externalTotalPrice;
  }

  public void setExternalTotalPrice(ExternalLineItemTotalPriceDraft externalTotalPrice) {
    this.externalTotalPrice = externalTotalPrice;
  }

  public BaseMoneyInput getExternalPrice() {
    return externalPrice;
  }

  public void setExternalPrice(BaseMoneyInput externalPrice) {
    this.externalPrice = externalPrice;
  }

  public List<MethodExternalTaxRateDraft> getPerMethodExternalTaxRate() {
    return perMethodExternalTaxRate;
  }

  public void setPerMethodExternalTaxRate(
      List<MethodExternalTaxRateDraft> perMethodExternalTaxRate) {
    this.perMethodExternalTaxRate = perMethodExternalTaxRate;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public ResourceIdentifierInput getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  public ResourceIdentifierInput getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(ResourceIdentifierInput supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getProductId() {
    return productId;
  }

  public void setProductId(String productId) {
    this.productId = productId;
  }

  @Override
  public String toString() {
    return "AddStagedOrderLineItem{addedAt='" + addedAt + "', shippingDetails='" + shippingDetails + "', inventoryMode='" + inventoryMode + "', externalTotalPrice='" + externalTotalPrice + "', externalPrice='" + externalPrice + "', perMethodExternalTaxRate='" + perMethodExternalTaxRate + "', externalTaxRate='" + externalTaxRate + "', custom='" + custom + "', distributionChannel='" + distributionChannel + "', supplyChannel='" + supplyChannel + "', variantId='" + variantId + "', quantity='" + quantity + "', key='" + key + "', sku='" + sku + "', productId='" + productId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderLineItem that = (AddStagedOrderLineItem) o;
    return Objects.equals(addedAt, that.addedAt) &&
        Objects.equals(shippingDetails, that.shippingDetails) &&
        Objects.equals(inventoryMode, that.inventoryMode) &&
        Objects.equals(externalTotalPrice, that.externalTotalPrice) &&
        Objects.equals(externalPrice, that.externalPrice) &&
        Objects.equals(perMethodExternalTaxRate, that.perMethodExternalTaxRate) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(distributionChannel, that.distributionChannel) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(key, that.key) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(productId, that.productId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addedAt, shippingDetails, inventoryMode, externalTotalPrice, externalPrice, perMethodExternalTaxRate, externalTaxRate, custom, distributionChannel, supplyChannel, variantId, quantity, key, sku, productId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime addedAt;

    private ItemShippingDetailsDraftType shippingDetails;

    private InventoryMode inventoryMode;

    private ExternalLineItemTotalPriceDraft externalTotalPrice;

    private BaseMoneyInput externalPrice;

    private List<MethodExternalTaxRateDraft> perMethodExternalTaxRate = Collections.emptyList();

    private ExternalTaxRateDraft externalTaxRate;

    private CustomFieldsDraft custom;

    private ResourceIdentifierInput distributionChannel;

    private ResourceIdentifierInput supplyChannel;

    private Integer variantId;

    private Long quantity;

    private String key;

    private String sku;

    private String productId;

    public AddStagedOrderLineItem build() {
      AddStagedOrderLineItem result = new AddStagedOrderLineItem();
      result.addedAt = this.addedAt;
      result.shippingDetails = this.shippingDetails;
      result.inventoryMode = this.inventoryMode;
      result.externalTotalPrice = this.externalTotalPrice;
      result.externalPrice = this.externalPrice;
      result.perMethodExternalTaxRate = this.perMethodExternalTaxRate;
      result.externalTaxRate = this.externalTaxRate;
      result.custom = this.custom;
      result.distributionChannel = this.distributionChannel;
      result.supplyChannel = this.supplyChannel;
      result.variantId = this.variantId;
      result.quantity = this.quantity;
      result.key = this.key;
      result.sku = this.sku;
      result.productId = this.productId;
      return result;
    }

    public Builder addedAt(OffsetDateTime addedAt) {
      this.addedAt = addedAt;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraftType shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }

    public Builder inventoryMode(InventoryMode inventoryMode) {
      this.inventoryMode = inventoryMode;
      return this;
    }

    public Builder externalTotalPrice(ExternalLineItemTotalPriceDraft externalTotalPrice) {
      this.externalTotalPrice = externalTotalPrice;
      return this;
    }

    public Builder externalPrice(BaseMoneyInput externalPrice) {
      this.externalPrice = externalPrice;
      return this;
    }

    public Builder perMethodExternalTaxRate(
        List<MethodExternalTaxRateDraft> perMethodExternalTaxRate) {
      this.perMethodExternalTaxRate = perMethodExternalTaxRate;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder distributionChannel(ResourceIdentifierInput distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }

    public Builder supplyChannel(ResourceIdentifierInput supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder productId(String productId) {
      this.productId = productId;
      return this;
    }
  }
}
