package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AddStagedOrderReturnInfoOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private List<ReturnItemDraftTypeOutput> items;

  private OffsetDateTime returnDate;

  private String returnTrackingId;

  public AddStagedOrderReturnInfoOutput() {
  }

  public AddStagedOrderReturnInfoOutput(String type, List<ReturnItemDraftTypeOutput> items,
      OffsetDateTime returnDate, String returnTrackingId) {
    this.type = type;
    this.items = items;
    this.returnDate = returnDate;
    this.returnTrackingId = returnTrackingId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public List<ReturnItemDraftTypeOutput> getItems() {
    return items;
  }

  public void setItems(List<ReturnItemDraftTypeOutput> items) {
    this.items = items;
  }

  public OffsetDateTime getReturnDate() {
    return returnDate;
  }

  public void setReturnDate(OffsetDateTime returnDate) {
    this.returnDate = returnDate;
  }

  public String getReturnTrackingId() {
    return returnTrackingId;
  }

  public void setReturnTrackingId(String returnTrackingId) {
    this.returnTrackingId = returnTrackingId;
  }

  @Override
  public String toString() {
    return "AddStagedOrderReturnInfoOutput{type='" + type + "', items='" + items + "', returnDate='" + returnDate + "', returnTrackingId='" + returnTrackingId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderReturnInfoOutput that = (AddStagedOrderReturnInfoOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(items, that.items) &&
        Objects.equals(returnDate, that.returnDate) &&
        Objects.equals(returnTrackingId, that.returnTrackingId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, items, returnDate, returnTrackingId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private List<ReturnItemDraftTypeOutput> items;

    private OffsetDateTime returnDate;

    private String returnTrackingId;

    public AddStagedOrderReturnInfoOutput build() {
      AddStagedOrderReturnInfoOutput result = new AddStagedOrderReturnInfoOutput();
      result.type = this.type;
      result.items = this.items;
      result.returnDate = this.returnDate;
      result.returnTrackingId = this.returnTrackingId;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder items(List<ReturnItemDraftTypeOutput> items) {
      this.items = items;
      return this;
    }

    public Builder returnDate(OffsetDateTime returnDate) {
      this.returnDate = returnDate;
      return this;
    }

    public Builder returnTrackingId(String returnTrackingId) {
      this.returnTrackingId = returnTrackingId;
      return this;
    }
  }
}
