package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddStagedOrderShoppingList {
  private ResourceIdentifierInput shoppingList;

  private ResourceIdentifierInput supplyChannel;

  private ResourceIdentifierInput distributionChannel;

  public AddStagedOrderShoppingList() {
  }

  public AddStagedOrderShoppingList(ResourceIdentifierInput shoppingList,
      ResourceIdentifierInput supplyChannel, ResourceIdentifierInput distributionChannel) {
    this.shoppingList = shoppingList;
    this.supplyChannel = supplyChannel;
    this.distributionChannel = distributionChannel;
  }

  public ResourceIdentifierInput getShoppingList() {
    return shoppingList;
  }

  public void setShoppingList(ResourceIdentifierInput shoppingList) {
    this.shoppingList = shoppingList;
  }

  public ResourceIdentifierInput getSupplyChannel() {
    return supplyChannel;
  }

  public void setSupplyChannel(ResourceIdentifierInput supplyChannel) {
    this.supplyChannel = supplyChannel;
  }

  public ResourceIdentifierInput getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  @Override
  public String toString() {
    return "AddStagedOrderShoppingList{shoppingList='" + shoppingList + "', supplyChannel='" + supplyChannel + "', distributionChannel='" + distributionChannel + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderShoppingList that = (AddStagedOrderShoppingList) o;
    return Objects.equals(shoppingList, that.shoppingList) &&
        Objects.equals(supplyChannel, that.supplyChannel) &&
        Objects.equals(distributionChannel, that.distributionChannel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shoppingList, supplyChannel, distributionChannel);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput shoppingList;

    private ResourceIdentifierInput supplyChannel;

    private ResourceIdentifierInput distributionChannel;

    public AddStagedOrderShoppingList build() {
      AddStagedOrderShoppingList result = new AddStagedOrderShoppingList();
      result.shoppingList = this.shoppingList;
      result.supplyChannel = this.supplyChannel;
      result.distributionChannel = this.distributionChannel;
      return result;
    }

    public Builder shoppingList(ResourceIdentifierInput shoppingList) {
      this.shoppingList = shoppingList;
      return this;
    }

    public Builder supplyChannel(ResourceIdentifierInput supplyChannel) {
      this.supplyChannel = supplyChannel;
      return this;
    }

    public Builder distributionChannel(ResourceIdentifierInput distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }
  }
}
