package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AddStagedOrderShoppingListOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ResourceIdentifier shoppingListResId;

  private ChannelReferenceIdentifier supplyChannelResId;

  private ChannelReferenceIdentifier distributionChannelResId;

  public AddStagedOrderShoppingListOutput() {
  }

  public AddStagedOrderShoppingListOutput(String type, ResourceIdentifier shoppingListResId,
      ChannelReferenceIdentifier supplyChannelResId,
      ChannelReferenceIdentifier distributionChannelResId) {
    this.type = type;
    this.shoppingListResId = shoppingListResId;
    this.supplyChannelResId = supplyChannelResId;
    this.distributionChannelResId = distributionChannelResId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ResourceIdentifier getShoppingListResId() {
    return shoppingListResId;
  }

  public void setShoppingListResId(ResourceIdentifier shoppingListResId) {
    this.shoppingListResId = shoppingListResId;
  }

  public ChannelReferenceIdentifier getSupplyChannelResId() {
    return supplyChannelResId;
  }

  public void setSupplyChannelResId(ChannelReferenceIdentifier supplyChannelResId) {
    this.supplyChannelResId = supplyChannelResId;
  }

  public ChannelReferenceIdentifier getDistributionChannelResId() {
    return distributionChannelResId;
  }

  public void setDistributionChannelResId(ChannelReferenceIdentifier distributionChannelResId) {
    this.distributionChannelResId = distributionChannelResId;
  }

  @Override
  public String toString() {
    return "AddStagedOrderShoppingListOutput{type='" + type + "', shoppingListResId='" + shoppingListResId + "', supplyChannelResId='" + supplyChannelResId + "', distributionChannelResId='" + distributionChannelResId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStagedOrderShoppingListOutput that = (AddStagedOrderShoppingListOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(shoppingListResId, that.shoppingListResId) &&
        Objects.equals(supplyChannelResId, that.supplyChannelResId) &&
        Objects.equals(distributionChannelResId, that.distributionChannelResId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, shoppingListResId, supplyChannelResId, distributionChannelResId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ResourceIdentifier shoppingListResId;

    private ChannelReferenceIdentifier supplyChannelResId;

    private ChannelReferenceIdentifier distributionChannelResId;

    public AddStagedOrderShoppingListOutput build() {
      AddStagedOrderShoppingListOutput result = new AddStagedOrderShoppingListOutput();
      result.type = this.type;
      result.shoppingListResId = this.shoppingListResId;
      result.supplyChannelResId = this.supplyChannelResId;
      result.distributionChannelResId = this.distributionChannelResId;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder shoppingListResId(ResourceIdentifier shoppingListResId) {
      this.shoppingListResId = shoppingListResId;
      return this;
    }

    public Builder supplyChannelResId(ChannelReferenceIdentifier supplyChannelResId) {
      this.supplyChannelResId = supplyChannelResId;
      return this;
    }

    public Builder distributionChannelResId(ChannelReferenceIdentifier distributionChannelResId) {
      this.distributionChannelResId = distributionChannelResId;
      return this;
    }
  }
}
