package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddStandalonePriceTier {
  private ProductPriceTierInput tier;

  public AddStandalonePriceTier() {
  }

  public AddStandalonePriceTier(ProductPriceTierInput tier) {
    this.tier = tier;
  }

  public ProductPriceTierInput getTier() {
    return tier;
  }

  public void setTier(ProductPriceTierInput tier) {
    this.tier = tier;
  }

  @Override
  public String toString() {
    return "AddStandalonePriceTier{tier='" + tier + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddStandalonePriceTier that = (AddStandalonePriceTier) o;
    return Objects.equals(tier, that.tier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tier);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductPriceTierInput tier;

    public AddStandalonePriceTier build() {
      AddStandalonePriceTier result = new AddStandalonePriceTier();
      result.tier = this.tier;
      return result;
    }

    public Builder tier(ProductPriceTierInput tier) {
      this.tier = tier;
      return this;
    }
  }
}
