package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AddressDraft {
  private String id;

  private String streetName;

  private String streetNumber;

  private String additionalStreetInfo;

  private String postalCode;

  private String city;

  private String region;

  private String state;

  private String country;

  private String company;

  private String department;

  private String building;

  private String apartment;

  private String pOBox;

  private String additionalAddressInfo;

  private String externalId;

  private String key;

  private CustomFieldsCommand custom;

  private String phone;

  private String mobile;

  private String email;

  private String fax;

  private String title;

  private String salutation;

  private String firstName;

  private String lastName;

  public AddressDraft() {
  }

  public AddressDraft(String id, String streetName, String streetNumber,
      String additionalStreetInfo, String postalCode, String city, String region, String state,
      String country, String company, String department, String building, String apartment,
      String pOBox, String additionalAddressInfo, String externalId, String key,
      CustomFieldsCommand custom, String phone, String mobile, String email, String fax,
      String title, String salutation, String firstName, String lastName) {
    this.id = id;
    this.streetName = streetName;
    this.streetNumber = streetNumber;
    this.additionalStreetInfo = additionalStreetInfo;
    this.postalCode = postalCode;
    this.city = city;
    this.region = region;
    this.state = state;
    this.country = country;
    this.company = company;
    this.department = department;
    this.building = building;
    this.apartment = apartment;
    this.pOBox = pOBox;
    this.additionalAddressInfo = additionalAddressInfo;
    this.externalId = externalId;
    this.key = key;
    this.custom = custom;
    this.phone = phone;
    this.mobile = mobile;
    this.email = email;
    this.fax = fax;
    this.title = title;
    this.salutation = salutation;
    this.firstName = firstName;
    this.lastName = lastName;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getStreetName() {
    return streetName;
  }

  public void setStreetName(String streetName) {
    this.streetName = streetName;
  }

  public String getStreetNumber() {
    return streetNumber;
  }

  public void setStreetNumber(String streetNumber) {
    this.streetNumber = streetNumber;
  }

  public String getAdditionalStreetInfo() {
    return additionalStreetInfo;
  }

  public void setAdditionalStreetInfo(String additionalStreetInfo) {
    this.additionalStreetInfo = additionalStreetInfo;
  }

  public String getPostalCode() {
    return postalCode;
  }

  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }

  public String getCity() {
    return city;
  }

  public void setCity(String city) {
    this.city = city;
  }

  public String getRegion() {
    return region;
  }

  public void setRegion(String region) {
    this.region = region;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public String getCompany() {
    return company;
  }

  public void setCompany(String company) {
    this.company = company;
  }

  public String getDepartment() {
    return department;
  }

  public void setDepartment(String department) {
    this.department = department;
  }

  public String getBuilding() {
    return building;
  }

  public void setBuilding(String building) {
    this.building = building;
  }

  public String getApartment() {
    return apartment;
  }

  public void setApartment(String apartment) {
    this.apartment = apartment;
  }

  public String getPOBox() {
    return pOBox;
  }

  public void setPOBox(String pOBox) {
    this.pOBox = pOBox;
  }

  public String getAdditionalAddressInfo() {
    return additionalAddressInfo;
  }

  public void setAdditionalAddressInfo(String additionalAddressInfo) {
    this.additionalAddressInfo = additionalAddressInfo;
  }

  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getFax() {
    return fax;
  }

  public void setFax(String fax) {
    this.fax = fax;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public String getSalutation() {
    return salutation;
  }

  public void setSalutation(String salutation) {
    this.salutation = salutation;
  }

  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  @Override
  public String toString() {
    return "AddressDraft{id='" + id + "', streetName='" + streetName + "', streetNumber='" + streetNumber + "', additionalStreetInfo='" + additionalStreetInfo + "', postalCode='" + postalCode + "', city='" + city + "', region='" + region + "', state='" + state + "', country='" + country + "', company='" + company + "', department='" + department + "', building='" + building + "', apartment='" + apartment + "', pOBox='" + pOBox + "', additionalAddressInfo='" + additionalAddressInfo + "', externalId='" + externalId + "', key='" + key + "', custom='" + custom + "', phone='" + phone + "', mobile='" + mobile + "', email='" + email + "', fax='" + fax + "', title='" + title + "', salutation='" + salutation + "', firstName='" + firstName + "', lastName='" + lastName + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AddressDraft that = (AddressDraft) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(streetName, that.streetName) &&
        Objects.equals(streetNumber, that.streetNumber) &&
        Objects.equals(additionalStreetInfo, that.additionalStreetInfo) &&
        Objects.equals(postalCode, that.postalCode) &&
        Objects.equals(city, that.city) &&
        Objects.equals(region, that.region) &&
        Objects.equals(state, that.state) &&
        Objects.equals(country, that.country) &&
        Objects.equals(company, that.company) &&
        Objects.equals(department, that.department) &&
        Objects.equals(building, that.building) &&
        Objects.equals(apartment, that.apartment) &&
        Objects.equals(pOBox, that.pOBox) &&
        Objects.equals(additionalAddressInfo, that.additionalAddressInfo) &&
        Objects.equals(externalId, that.externalId) &&
        Objects.equals(key, that.key) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(phone, that.phone) &&
        Objects.equals(mobile, that.mobile) &&
        Objects.equals(email, that.email) &&
        Objects.equals(fax, that.fax) &&
        Objects.equals(title, that.title) &&
        Objects.equals(salutation, that.salutation) &&
        Objects.equals(firstName, that.firstName) &&
        Objects.equals(lastName, that.lastName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, streetName, streetNumber, additionalStreetInfo, postalCode, city, region, state, country, company, department, building, apartment, pOBox, additionalAddressInfo, externalId, key, custom, phone, mobile, email, fax, title, salutation, firstName, lastName);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private String streetName;

    private String streetNumber;

    private String additionalStreetInfo;

    private String postalCode;

    private String city;

    private String region;

    private String state;

    private String country;

    private String company;

    private String department;

    private String building;

    private String apartment;

    private String pOBox;

    private String additionalAddressInfo;

    private String externalId;

    private String key;

    private CustomFieldsCommand custom;

    private String phone;

    private String mobile;

    private String email;

    private String fax;

    private String title;

    private String salutation;

    private String firstName;

    private String lastName;

    public AddressDraft build() {
      AddressDraft result = new AddressDraft();
      result.id = this.id;
      result.streetName = this.streetName;
      result.streetNumber = this.streetNumber;
      result.additionalStreetInfo = this.additionalStreetInfo;
      result.postalCode = this.postalCode;
      result.city = this.city;
      result.region = this.region;
      result.state = this.state;
      result.country = this.country;
      result.company = this.company;
      result.department = this.department;
      result.building = this.building;
      result.apartment = this.apartment;
      result.pOBox = this.pOBox;
      result.additionalAddressInfo = this.additionalAddressInfo;
      result.externalId = this.externalId;
      result.key = this.key;
      result.custom = this.custom;
      result.phone = this.phone;
      result.mobile = this.mobile;
      result.email = this.email;
      result.fax = this.fax;
      result.title = this.title;
      result.salutation = this.salutation;
      result.firstName = this.firstName;
      result.lastName = this.lastName;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder streetName(String streetName) {
      this.streetName = streetName;
      return this;
    }

    public Builder streetNumber(String streetNumber) {
      this.streetNumber = streetNumber;
      return this;
    }

    public Builder additionalStreetInfo(String additionalStreetInfo) {
      this.additionalStreetInfo = additionalStreetInfo;
      return this;
    }

    public Builder postalCode(String postalCode) {
      this.postalCode = postalCode;
      return this;
    }

    public Builder city(String city) {
      this.city = city;
      return this;
    }

    public Builder region(String region) {
      this.region = region;
      return this;
    }

    public Builder state(String state) {
      this.state = state;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder company(String company) {
      this.company = company;
      return this;
    }

    public Builder department(String department) {
      this.department = department;
      return this;
    }

    public Builder building(String building) {
      this.building = building;
      return this;
    }

    public Builder apartment(String apartment) {
      this.apartment = apartment;
      return this;
    }

    public Builder pOBox(String pOBox) {
      this.pOBox = pOBox;
      return this;
    }

    public Builder additionalAddressInfo(String additionalAddressInfo) {
      this.additionalAddressInfo = additionalAddressInfo;
      return this;
    }

    public Builder externalId(String externalId) {
      this.externalId = externalId;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }

    public Builder phone(String phone) {
      this.phone = phone;
      return this;
    }

    public Builder mobile(String mobile) {
      this.mobile = mobile;
      return this;
    }

    public Builder email(String email) {
      this.email = email;
      return this;
    }

    public Builder fax(String fax) {
      this.fax = fax;
      return this;
    }

    public Builder title(String title) {
      this.title = title;
      return this;
    }

    public Builder salutation(String salutation) {
      this.salutation = salutation;
      return this;
    }

    public Builder firstName(String firstName) {
      this.firstName = firstName;
      return this;
    }

    public Builder lastName(String lastName) {
      this.lastName = lastName;
      return this;
    }
  }
}
