package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ApplyCartDeltaToCustomLineItemShippingDetailsTargets {
  private String customLineItemId;

  private String customLineItemKey;

  private List<ShippingTargetDraft> targetsDelta;

  public ApplyCartDeltaToCustomLineItemShippingDetailsTargets() {
  }

  public ApplyCartDeltaToCustomLineItemShippingDetailsTargets(String customLineItemId,
      String customLineItemKey, List<ShippingTargetDraft> targetsDelta) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.targetsDelta = targetsDelta;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public List<ShippingTargetDraft> getTargetsDelta() {
    return targetsDelta;
  }

  public void setTargetsDelta(List<ShippingTargetDraft> targetsDelta) {
    this.targetsDelta = targetsDelta;
  }

  @Override
  public String toString() {
    return "ApplyCartDeltaToCustomLineItemShippingDetailsTargets{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', targetsDelta='" + targetsDelta + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApplyCartDeltaToCustomLineItemShippingDetailsTargets that = (ApplyCartDeltaToCustomLineItemShippingDetailsTargets) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(targetsDelta, that.targetsDelta);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, targetsDelta);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private List<ShippingTargetDraft> targetsDelta;

    public ApplyCartDeltaToCustomLineItemShippingDetailsTargets build() {
      ApplyCartDeltaToCustomLineItemShippingDetailsTargets result = new ApplyCartDeltaToCustomLineItemShippingDetailsTargets();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.targetsDelta = this.targetsDelta;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder targetsDelta(List<ShippingTargetDraft> targetsDelta) {
      this.targetsDelta = targetsDelta;
      return this;
    }
  }
}
