package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ApplyCartDeltaToLineItemShippingDetailsTargets {
  private String lineItemId;

  private List<ShippingTargetDraft> targetsDelta;

  private String lineItemKey;

  public ApplyCartDeltaToLineItemShippingDetailsTargets() {
  }

  public ApplyCartDeltaToLineItemShippingDetailsTargets(String lineItemId,
      List<ShippingTargetDraft> targetsDelta, String lineItemKey) {
    this.lineItemId = lineItemId;
    this.targetsDelta = targetsDelta;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public List<ShippingTargetDraft> getTargetsDelta() {
    return targetsDelta;
  }

  public void setTargetsDelta(List<ShippingTargetDraft> targetsDelta) {
    this.targetsDelta = targetsDelta;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "ApplyCartDeltaToLineItemShippingDetailsTargets{lineItemId='" + lineItemId + "', targetsDelta='" + targetsDelta + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApplyCartDeltaToLineItemShippingDetailsTargets that = (ApplyCartDeltaToLineItemShippingDetailsTargets) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(targetsDelta, that.targetsDelta) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, targetsDelta, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private List<ShippingTargetDraft> targetsDelta;

    private String lineItemKey;

    public ApplyCartDeltaToLineItemShippingDetailsTargets build() {
      ApplyCartDeltaToLineItemShippingDetailsTargets result = new ApplyCartDeltaToLineItemShippingDetailsTargets();
      result.lineItemId = this.lineItemId;
      result.targetsDelta = this.targetsDelta;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder targetsDelta(List<ShippingTargetDraft> targetsDelta) {
      this.targetsDelta = targetsDelta;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
