package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalFlowCompleted implements com.commercetools.graphql.api.types.MessagePayload {
  private String status;

  private Order order;

  private Reference orderRef;

  private String type;

  public ApprovalFlowCompleted() {
  }

  public ApprovalFlowCompleted(String status, Order order, Reference orderRef, String type) {
    this.status = status;
    this.order = order;
    this.orderRef = orderRef;
    this.type = type;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Order getOrder() {
    return order;
  }

  public void setOrder(Order order) {
    this.order = order;
  }

  public Reference getOrderRef() {
    return orderRef;
  }

  public void setOrderRef(Reference orderRef) {
    this.orderRef = orderRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalFlowCompleted{status='" + status + "', order='" + order + "', orderRef='" + orderRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalFlowCompleted that = (ApprovalFlowCompleted) o;
    return Objects.equals(status, that.status) &&
        Objects.equals(order, that.order) &&
        Objects.equals(orderRef, that.orderRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, order, orderRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String status;

    private Order order;

    private Reference orderRef;

    private String type;

    public ApprovalFlowCompleted build() {
      ApprovalFlowCompleted result = new ApprovalFlowCompleted();
      result.status = this.status;
      result.order = this.order;
      result.orderRef = this.orderRef;
      result.type = this.type;
      return result;
    }

    public Builder status(String status) {
      this.status = status;
      return this;
    }

    public Builder order(Order order) {
      this.order = order;
      return this;
    }

    public Builder orderRef(Reference orderRef) {
      this.orderRef = orderRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
