package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ApprovalFlowUpdateAction {
  private RejectApprovalFlow reject;

  private SetApprovalFlowCustomField setCustomField;

  private SetApprovalFlowCustomType setCustomType;

  private ApproveApprovalFlow approve;

  public ApprovalFlowUpdateAction() {
  }

  public ApprovalFlowUpdateAction(RejectApprovalFlow reject,
      SetApprovalFlowCustomField setCustomField, SetApprovalFlowCustomType setCustomType,
      ApproveApprovalFlow approve) {
    this.reject = reject;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.approve = approve;
  }

  public RejectApprovalFlow getReject() {
    return reject;
  }

  public void setReject(RejectApprovalFlow reject) {
    this.reject = reject;
  }

  public SetApprovalFlowCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetApprovalFlowCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetApprovalFlowCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetApprovalFlowCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public ApproveApprovalFlow getApprove() {
    return approve;
  }

  public void setApprove(ApproveApprovalFlow approve) {
    this.approve = approve;
  }

  @Override
  public String toString() {
    return "ApprovalFlowUpdateAction{reject='" + reject + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', approve='" + approve + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalFlowUpdateAction that = (ApprovalFlowUpdateAction) o;
    return Objects.equals(reject, that.reject) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(approve, that.approve);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reject, setCustomField, setCustomType, approve);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private RejectApprovalFlow reject;

    private SetApprovalFlowCustomField setCustomField;

    private SetApprovalFlowCustomType setCustomType;

    private ApproveApprovalFlow approve;

    public ApprovalFlowUpdateAction build() {
      ApprovalFlowUpdateAction result = new ApprovalFlowUpdateAction();
      result.reject = this.reject;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.approve = this.approve;
      return result;
    }

    public Builder reject(RejectApprovalFlow reject) {
      this.reject = reject;
      return this;
    }

    public Builder setCustomField(SetApprovalFlowCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetApprovalFlowCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder approve(ApproveApprovalFlow approve) {
      this.approve = approve;
      return this;
    }
  }
}
