package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalRuleApproversSet implements com.commercetools.graphql.api.types.MessagePayload {
  private ApproverHierarchy oldApprovers;

  private ApproverHierarchy approvers;

  private String type;

  public ApprovalRuleApproversSet() {
  }

  public ApprovalRuleApproversSet(ApproverHierarchy oldApprovers, ApproverHierarchy approvers,
      String type) {
    this.oldApprovers = oldApprovers;
    this.approvers = approvers;
    this.type = type;
  }

  public ApproverHierarchy getOldApprovers() {
    return oldApprovers;
  }

  public void setOldApprovers(ApproverHierarchy oldApprovers) {
    this.oldApprovers = oldApprovers;
  }

  public ApproverHierarchy getApprovers() {
    return approvers;
  }

  public void setApprovers(ApproverHierarchy approvers) {
    this.approvers = approvers;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalRuleApproversSet{oldApprovers='" + oldApprovers + "', approvers='" + approvers + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalRuleApproversSet that = (ApprovalRuleApproversSet) o;
    return Objects.equals(oldApprovers, that.oldApprovers) &&
        Objects.equals(approvers, that.approvers) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldApprovers, approvers, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ApproverHierarchy oldApprovers;

    private ApproverHierarchy approvers;

    private String type;

    public ApprovalRuleApproversSet build() {
      ApprovalRuleApproversSet result = new ApprovalRuleApproversSet();
      result.oldApprovers = this.oldApprovers;
      result.approvers = this.approvers;
      result.type = this.type;
      return result;
    }

    public Builder oldApprovers(ApproverHierarchy oldApprovers) {
      this.oldApprovers = oldApprovers;
      return this;
    }

    public Builder approvers(ApproverHierarchy approvers) {
      this.approvers = approvers;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
