package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalRuleKeySet implements com.commercetools.graphql.api.types.MessagePayload {
  private String oldKey;

  private String key;

  private String type;

  public ApprovalRuleKeySet() {
  }

  public ApprovalRuleKeySet(String oldKey, String key, String type) {
    this.oldKey = oldKey;
    this.key = key;
    this.type = type;
  }

  public String getOldKey() {
    return oldKey;
  }

  public void setOldKey(String oldKey) {
    this.oldKey = oldKey;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalRuleKeySet{oldKey='" + oldKey + "', key='" + key + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalRuleKeySet that = (ApprovalRuleKeySet) o;
    return Objects.equals(oldKey, that.oldKey) &&
        Objects.equals(key, that.key) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldKey, key, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String oldKey;

    private String key;

    private String type;

    public ApprovalRuleKeySet build() {
      ApprovalRuleKeySet result = new ApprovalRuleKeySet();
      result.oldKey = this.oldKey;
      result.key = this.key;
      result.type = this.type;
      return result;
    }

    public Builder oldKey(String oldKey) {
      this.oldKey = oldKey;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
