package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalRulePredicateSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String oldPredicate;

  private String predicate;

  private String type;

  public ApprovalRulePredicateSet() {
  }

  public ApprovalRulePredicateSet(String oldPredicate, String predicate, String type) {
    this.oldPredicate = oldPredicate;
    this.predicate = predicate;
    this.type = type;
  }

  public String getOldPredicate() {
    return oldPredicate;
  }

  public void setOldPredicate(String oldPredicate) {
    this.oldPredicate = oldPredicate;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalRulePredicateSet{oldPredicate='" + oldPredicate + "', predicate='" + predicate + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalRulePredicateSet that = (ApprovalRulePredicateSet) o;
    return Objects.equals(oldPredicate, that.oldPredicate) &&
        Objects.equals(predicate, that.predicate) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldPredicate, predicate, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String oldPredicate;

    private String predicate;

    private String type;

    public ApprovalRulePredicateSet build() {
      ApprovalRulePredicateSet result = new ApprovalRulePredicateSet();
      result.oldPredicate = this.oldPredicate;
      result.predicate = this.predicate;
      result.type = this.type;
      return result;
    }

    public Builder oldPredicate(String oldPredicate) {
      this.oldPredicate = oldPredicate;
      return this;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
