package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalRuleRequestersSet implements com.commercetools.graphql.api.types.MessagePayload {
  private List<RuleRequester> oldRequesters;

  private List<RuleRequester> requesters;

  private String type;

  public ApprovalRuleRequestersSet() {
  }

  public ApprovalRuleRequestersSet(List<RuleRequester> oldRequesters,
      List<RuleRequester> requesters, String type) {
    this.oldRequesters = oldRequesters;
    this.requesters = requesters;
    this.type = type;
  }

  public List<RuleRequester> getOldRequesters() {
    return oldRequesters;
  }

  public void setOldRequesters(List<RuleRequester> oldRequesters) {
    this.oldRequesters = oldRequesters;
  }

  public List<RuleRequester> getRequesters() {
    return requesters;
  }

  public void setRequesters(List<RuleRequester> requesters) {
    this.requesters = requesters;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalRuleRequestersSet{oldRequesters='" + oldRequesters + "', requesters='" + requesters + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalRuleRequestersSet that = (ApprovalRuleRequestersSet) o;
    return Objects.equals(oldRequesters, that.oldRequesters) &&
        Objects.equals(requesters, that.requesters) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldRequesters, requesters, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<RuleRequester> oldRequesters;

    private List<RuleRequester> requesters;

    private String type;

    public ApprovalRuleRequestersSet build() {
      ApprovalRuleRequestersSet result = new ApprovalRuleRequestersSet();
      result.oldRequesters = this.oldRequesters;
      result.requesters = this.requesters;
      result.type = this.type;
      return result;
    }

    public Builder oldRequesters(List<RuleRequester> oldRequesters) {
      this.oldRequesters = oldRequesters;
      return this;
    }

    public Builder requesters(List<RuleRequester> requesters) {
      this.requesters = requesters;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
