package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ApprovalRuleStatusSet implements com.commercetools.graphql.api.types.MessagePayload {
  private ApprovalRuleStatus oldStatus;

  private ApprovalRuleStatus status;

  private String type;

  public ApprovalRuleStatusSet() {
  }

  public ApprovalRuleStatusSet(ApprovalRuleStatus oldStatus, ApprovalRuleStatus status,
      String type) {
    this.oldStatus = oldStatus;
    this.status = status;
    this.type = type;
  }

  public ApprovalRuleStatus getOldStatus() {
    return oldStatus;
  }

  public void setOldStatus(ApprovalRuleStatus oldStatus) {
    this.oldStatus = oldStatus;
  }

  public ApprovalRuleStatus getStatus() {
    return status;
  }

  public void setStatus(ApprovalRuleStatus status) {
    this.status = status;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ApprovalRuleStatusSet{oldStatus='" + oldStatus + "', status='" + status + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalRuleStatusSet that = (ApprovalRuleStatusSet) o;
    return Objects.equals(oldStatus, that.oldStatus) &&
        Objects.equals(status, that.status) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldStatus, status, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ApprovalRuleStatus oldStatus;

    private ApprovalRuleStatus status;

    private String type;

    public ApprovalRuleStatusSet build() {
      ApprovalRuleStatusSet result = new ApprovalRuleStatusSet();
      result.oldStatus = this.oldStatus;
      result.status = this.status;
      result.type = this.type;
      return result;
    }

    public Builder oldStatus(ApprovalRuleStatus oldStatus) {
      this.oldStatus = oldStatus;
      return this;
    }

    public Builder status(ApprovalRuleStatus status) {
      this.status = status;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
