package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ApprovalRuleUpdateAction {
  private SetApprovalRuleKey setKey;

  private SetApprovalRuleName setName;

  private SetApprovalRuleDescription setDescription;

  private SetApprovalRulePredicate setPredicate;

  private SetApprovalRuleRequesters setRequesters;

  private SetApprovalRuleStatus setStatus;

  private SetApprovalRuleApprovers setApprovers;

  private SetApprovalRuleCustomField setCustomField;

  private SetApprovalRuleCustomType setCustomType;

  public ApprovalRuleUpdateAction() {
  }

  public ApprovalRuleUpdateAction(SetApprovalRuleKey setKey, SetApprovalRuleName setName,
      SetApprovalRuleDescription setDescription, SetApprovalRulePredicate setPredicate,
      SetApprovalRuleRequesters setRequesters, SetApprovalRuleStatus setStatus,
      SetApprovalRuleApprovers setApprovers, SetApprovalRuleCustomField setCustomField,
      SetApprovalRuleCustomType setCustomType) {
    this.setKey = setKey;
    this.setName = setName;
    this.setDescription = setDescription;
    this.setPredicate = setPredicate;
    this.setRequesters = setRequesters;
    this.setStatus = setStatus;
    this.setApprovers = setApprovers;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
  }

  public SetApprovalRuleKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetApprovalRuleKey setKey) {
    this.setKey = setKey;
  }

  public SetApprovalRuleName getSetName() {
    return setName;
  }

  public void setSetName(SetApprovalRuleName setName) {
    this.setName = setName;
  }

  public SetApprovalRuleDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetApprovalRuleDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetApprovalRulePredicate getSetPredicate() {
    return setPredicate;
  }

  public void setSetPredicate(SetApprovalRulePredicate setPredicate) {
    this.setPredicate = setPredicate;
  }

  public SetApprovalRuleRequesters getSetRequesters() {
    return setRequesters;
  }

  public void setSetRequesters(SetApprovalRuleRequesters setRequesters) {
    this.setRequesters = setRequesters;
  }

  public SetApprovalRuleStatus getSetStatus() {
    return setStatus;
  }

  public void setSetStatus(SetApprovalRuleStatus setStatus) {
    this.setStatus = setStatus;
  }

  public SetApprovalRuleApprovers getSetApprovers() {
    return setApprovers;
  }

  public void setSetApprovers(SetApprovalRuleApprovers setApprovers) {
    this.setApprovers = setApprovers;
  }

  public SetApprovalRuleCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetApprovalRuleCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetApprovalRuleCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetApprovalRuleCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  @Override
  public String toString() {
    return "ApprovalRuleUpdateAction{setKey='" + setKey + "', setName='" + setName + "', setDescription='" + setDescription + "', setPredicate='" + setPredicate + "', setRequesters='" + setRequesters + "', setStatus='" + setStatus + "', setApprovers='" + setApprovers + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApprovalRuleUpdateAction that = (ApprovalRuleUpdateAction) o;
    return Objects.equals(setKey, that.setKey) &&
        Objects.equals(setName, that.setName) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setPredicate, that.setPredicate) &&
        Objects.equals(setRequesters, that.setRequesters) &&
        Objects.equals(setStatus, that.setStatus) &&
        Objects.equals(setApprovers, that.setApprovers) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(setKey, setName, setDescription, setPredicate, setRequesters, setStatus, setApprovers, setCustomField, setCustomType);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private SetApprovalRuleKey setKey;

    private SetApprovalRuleName setName;

    private SetApprovalRuleDescription setDescription;

    private SetApprovalRulePredicate setPredicate;

    private SetApprovalRuleRequesters setRequesters;

    private SetApprovalRuleStatus setStatus;

    private SetApprovalRuleApprovers setApprovers;

    private SetApprovalRuleCustomField setCustomField;

    private SetApprovalRuleCustomType setCustomType;

    public ApprovalRuleUpdateAction build() {
      ApprovalRuleUpdateAction result = new ApprovalRuleUpdateAction();
      result.setKey = this.setKey;
      result.setName = this.setName;
      result.setDescription = this.setDescription;
      result.setPredicate = this.setPredicate;
      result.setRequesters = this.setRequesters;
      result.setStatus = this.setStatus;
      result.setApprovers = this.setApprovers;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      return result;
    }

    public Builder setKey(SetApprovalRuleKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setName(SetApprovalRuleName setName) {
      this.setName = setName;
      return this;
    }

    public Builder setDescription(SetApprovalRuleDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setPredicate(SetApprovalRulePredicate setPredicate) {
      this.setPredicate = setPredicate;
      return this;
    }

    public Builder setRequesters(SetApprovalRuleRequesters setRequesters) {
      this.setRequesters = setRequesters;
      return this;
    }

    public Builder setStatus(SetApprovalRuleStatus setStatus) {
      this.setStatus = setStatus;
      return this;
    }

    public Builder setApprovers(SetApprovalRuleApprovers setApprovers) {
      this.setApprovers = setApprovers;
      return this;
    }

    public Builder setCustomField(SetApprovalRuleCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetApprovalRuleCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }
  }
}
