package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ApproverConjunctionDraft {
  private List<ApproverDisjunctionDraft> and;

  public ApproverConjunctionDraft() {
  }

  public ApproverConjunctionDraft(List<ApproverDisjunctionDraft> and) {
    this.and = and;
  }

  public List<ApproverDisjunctionDraft> getAnd() {
    return and;
  }

  public void setAnd(List<ApproverDisjunctionDraft> and) {
    this.and = and;
  }

  @Override
  public String toString() {
    return "ApproverConjunctionDraft{and='" + and + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApproverConjunctionDraft that = (ApproverConjunctionDraft) o;
    return Objects.equals(and, that.and);
  }

  @Override
  public int hashCode() {
    return Objects.hash(and);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ApproverDisjunctionDraft> and;

    public ApproverConjunctionDraft build() {
      ApproverConjunctionDraft result = new ApproverConjunctionDraft();
      result.and = this.and;
      return result;
    }

    public Builder and(List<ApproverDisjunctionDraft> and) {
      this.and = and;
      return this;
    }
  }
}
