package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ApproverDisjunction {
  private List<RuleApprover> or;

  public ApproverDisjunction() {
  }

  public ApproverDisjunction(List<RuleApprover> or) {
    this.or = or;
  }

  public List<RuleApprover> getOr() {
    return or;
  }

  public void setOr(List<RuleApprover> or) {
    this.or = or;
  }

  @Override
  public String toString() {
    return "ApproverDisjunction{or='" + or + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApproverDisjunction that = (ApproverDisjunction) o;
    return Objects.equals(or, that.or);
  }

  @Override
  public int hashCode() {
    return Objects.hash(or);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<RuleApprover> or;

    public ApproverDisjunction build() {
      ApproverDisjunction result = new ApproverDisjunction();
      result.or = this.or;
      return result;
    }

    public Builder or(List<RuleApprover> or) {
      this.or = or;
      return this;
    }
  }
}
