package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ApproverHierarchyDraft {
  private List<ApproverConjunctionDraft> tiers;

  public ApproverHierarchyDraft() {
  }

  public ApproverHierarchyDraft(List<ApproverConjunctionDraft> tiers) {
    this.tiers = tiers;
  }

  public List<ApproverConjunctionDraft> getTiers() {
    return tiers;
  }

  public void setTiers(List<ApproverConjunctionDraft> tiers) {
    this.tiers = tiers;
  }

  @Override
  public String toString() {
    return "ApproverHierarchyDraft{tiers='" + tiers + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApproverHierarchyDraft that = (ApproverHierarchyDraft) o;
    return Objects.equals(tiers, that.tiers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tiers);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ApproverConjunctionDraft> tiers;

    public ApproverHierarchyDraft build() {
      ApproverHierarchyDraft result = new ApproverHierarchyDraft();
      result.tiers = this.tiers;
      return result;
    }

    public Builder tiers(List<ApproverConjunctionDraft> tiers) {
      this.tiers = tiers;
      return this;
    }
  }
}
