package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AsAssociate implements com.commercetools.graphql.api.types.CartQueryInterface, com.commercetools.graphql.api.types.OrderQueryInterface, com.commercetools.graphql.api.types.QuoteQueryInterface, com.commercetools.graphql.api.types.QuoteRequestQueryInterface, com.commercetools.graphql.api.types.ShoppingListQueryInterface {
  private Cart cart;

  private CartQueryResult carts;

  private Order order;

  private OrderQueryResult orders;

  private ShoppingList shoppingList;

  private ShoppingListQueryResult shoppingLists;

  private QuoteRequest quoteRequest;

  private QuoteRequestQueryResult quoteRequests;

  private Quote quote;

  private QuoteQueryResult quotes;

  private ApprovalRule approvalRule;

  private ApprovalRuleQueryResult approvalRules;

  private ApprovalFlow approvalFlow;

  private ApprovalFlowQueryResult approvalFlows;

  private BusinessUnit businessUnit;

  private BusinessUnitQueryResult businessUnits;

  public AsAssociate() {
  }

  public AsAssociate(Cart cart, CartQueryResult carts, Order order, OrderQueryResult orders,
      ShoppingList shoppingList, ShoppingListQueryResult shoppingLists, QuoteRequest quoteRequest,
      QuoteRequestQueryResult quoteRequests, Quote quote, QuoteQueryResult quotes,
      ApprovalRule approvalRule, ApprovalRuleQueryResult approvalRules, ApprovalFlow approvalFlow,
      ApprovalFlowQueryResult approvalFlows, BusinessUnit businessUnit,
      BusinessUnitQueryResult businessUnits) {
    this.cart = cart;
    this.carts = carts;
    this.order = order;
    this.orders = orders;
    this.shoppingList = shoppingList;
    this.shoppingLists = shoppingLists;
    this.quoteRequest = quoteRequest;
    this.quoteRequests = quoteRequests;
    this.quote = quote;
    this.quotes = quotes;
    this.approvalRule = approvalRule;
    this.approvalRules = approvalRules;
    this.approvalFlow = approvalFlow;
    this.approvalFlows = approvalFlows;
    this.businessUnit = businessUnit;
    this.businessUnits = businessUnits;
  }

  public Cart getCart() {
    return cart;
  }

  public void setCart(Cart cart) {
    this.cart = cart;
  }

  public CartQueryResult getCarts() {
    return carts;
  }

  public void setCarts(CartQueryResult carts) {
    this.carts = carts;
  }

  public Order getOrder() {
    return order;
  }

  public void setOrder(Order order) {
    this.order = order;
  }

  public OrderQueryResult getOrders() {
    return orders;
  }

  public void setOrders(OrderQueryResult orders) {
    this.orders = orders;
  }

  public ShoppingList getShoppingList() {
    return shoppingList;
  }

  public void setShoppingList(ShoppingList shoppingList) {
    this.shoppingList = shoppingList;
  }

  public ShoppingListQueryResult getShoppingLists() {
    return shoppingLists;
  }

  public void setShoppingLists(ShoppingListQueryResult shoppingLists) {
    this.shoppingLists = shoppingLists;
  }

  public QuoteRequest getQuoteRequest() {
    return quoteRequest;
  }

  public void setQuoteRequest(QuoteRequest quoteRequest) {
    this.quoteRequest = quoteRequest;
  }

  public QuoteRequestQueryResult getQuoteRequests() {
    return quoteRequests;
  }

  public void setQuoteRequests(QuoteRequestQueryResult quoteRequests) {
    this.quoteRequests = quoteRequests;
  }

  public Quote getQuote() {
    return quote;
  }

  public void setQuote(Quote quote) {
    this.quote = quote;
  }

  public QuoteQueryResult getQuotes() {
    return quotes;
  }

  public void setQuotes(QuoteQueryResult quotes) {
    this.quotes = quotes;
  }

  public ApprovalRule getApprovalRule() {
    return approvalRule;
  }

  public void setApprovalRule(ApprovalRule approvalRule) {
    this.approvalRule = approvalRule;
  }

  public ApprovalRuleQueryResult getApprovalRules() {
    return approvalRules;
  }

  public void setApprovalRules(ApprovalRuleQueryResult approvalRules) {
    this.approvalRules = approvalRules;
  }

  public ApprovalFlow getApprovalFlow() {
    return approvalFlow;
  }

  public void setApprovalFlow(ApprovalFlow approvalFlow) {
    this.approvalFlow = approvalFlow;
  }

  public ApprovalFlowQueryResult getApprovalFlows() {
    return approvalFlows;
  }

  public void setApprovalFlows(ApprovalFlowQueryResult approvalFlows) {
    this.approvalFlows = approvalFlows;
  }

  public BusinessUnit getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(BusinessUnit businessUnit) {
    this.businessUnit = businessUnit;
  }

  public BusinessUnitQueryResult getBusinessUnits() {
    return businessUnits;
  }

  public void setBusinessUnits(BusinessUnitQueryResult businessUnits) {
    this.businessUnits = businessUnits;
  }

  @Override
  public String toString() {
    return "AsAssociate{cart='" + cart + "', carts='" + carts + "', order='" + order + "', orders='" + orders + "', shoppingList='" + shoppingList + "', shoppingLists='" + shoppingLists + "', quoteRequest='" + quoteRequest + "', quoteRequests='" + quoteRequests + "', quote='" + quote + "', quotes='" + quotes + "', approvalRule='" + approvalRule + "', approvalRules='" + approvalRules + "', approvalFlow='" + approvalFlow + "', approvalFlows='" + approvalFlows + "', businessUnit='" + businessUnit + "', businessUnits='" + businessUnits + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsAssociate that = (AsAssociate) o;
    return Objects.equals(cart, that.cart) &&
        Objects.equals(carts, that.carts) &&
        Objects.equals(order, that.order) &&
        Objects.equals(orders, that.orders) &&
        Objects.equals(shoppingList, that.shoppingList) &&
        Objects.equals(shoppingLists, that.shoppingLists) &&
        Objects.equals(quoteRequest, that.quoteRequest) &&
        Objects.equals(quoteRequests, that.quoteRequests) &&
        Objects.equals(quote, that.quote) &&
        Objects.equals(quotes, that.quotes) &&
        Objects.equals(approvalRule, that.approvalRule) &&
        Objects.equals(approvalRules, that.approvalRules) &&
        Objects.equals(approvalFlow, that.approvalFlow) &&
        Objects.equals(approvalFlows, that.approvalFlows) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(businessUnits, that.businessUnits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cart, carts, order, orders, shoppingList, shoppingLists, quoteRequest, quoteRequests, quote, quotes, approvalRule, approvalRules, approvalFlow, approvalFlows, businessUnit, businessUnits);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Cart cart;

    private CartQueryResult carts;

    private Order order;

    private OrderQueryResult orders;

    private ShoppingList shoppingList;

    private ShoppingListQueryResult shoppingLists;

    private QuoteRequest quoteRequest;

    private QuoteRequestQueryResult quoteRequests;

    private Quote quote;

    private QuoteQueryResult quotes;

    private ApprovalRule approvalRule;

    private ApprovalRuleQueryResult approvalRules;

    private ApprovalFlow approvalFlow;

    private ApprovalFlowQueryResult approvalFlows;

    private BusinessUnit businessUnit;

    private BusinessUnitQueryResult businessUnits;

    public AsAssociate build() {
      AsAssociate result = new AsAssociate();
      result.cart = this.cart;
      result.carts = this.carts;
      result.order = this.order;
      result.orders = this.orders;
      result.shoppingList = this.shoppingList;
      result.shoppingLists = this.shoppingLists;
      result.quoteRequest = this.quoteRequest;
      result.quoteRequests = this.quoteRequests;
      result.quote = this.quote;
      result.quotes = this.quotes;
      result.approvalRule = this.approvalRule;
      result.approvalRules = this.approvalRules;
      result.approvalFlow = this.approvalFlow;
      result.approvalFlows = this.approvalFlows;
      result.businessUnit = this.businessUnit;
      result.businessUnits = this.businessUnits;
      return result;
    }

    public Builder cart(Cart cart) {
      this.cart = cart;
      return this;
    }

    public Builder carts(CartQueryResult carts) {
      this.carts = carts;
      return this;
    }

    public Builder order(Order order) {
      this.order = order;
      return this;
    }

    public Builder orders(OrderQueryResult orders) {
      this.orders = orders;
      return this;
    }

    public Builder shoppingList(ShoppingList shoppingList) {
      this.shoppingList = shoppingList;
      return this;
    }

    public Builder shoppingLists(ShoppingListQueryResult shoppingLists) {
      this.shoppingLists = shoppingLists;
      return this;
    }

    public Builder quoteRequest(QuoteRequest quoteRequest) {
      this.quoteRequest = quoteRequest;
      return this;
    }

    public Builder quoteRequests(QuoteRequestQueryResult quoteRequests) {
      this.quoteRequests = quoteRequests;
      return this;
    }

    public Builder quote(Quote quote) {
      this.quote = quote;
      return this;
    }

    public Builder quotes(QuoteQueryResult quotes) {
      this.quotes = quotes;
      return this;
    }

    public Builder approvalRule(ApprovalRule approvalRule) {
      this.approvalRule = approvalRule;
      return this;
    }

    public Builder approvalRules(ApprovalRuleQueryResult approvalRules) {
      this.approvalRules = approvalRules;
      return this;
    }

    public Builder approvalFlow(ApprovalFlow approvalFlow) {
      this.approvalFlow = approvalFlow;
      return this;
    }

    public Builder approvalFlows(ApprovalFlowQueryResult approvalFlows) {
      this.approvalFlows = approvalFlows;
      return this;
    }

    public Builder businessUnit(BusinessUnit businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder businessUnits(BusinessUnitQueryResult businessUnits) {
      this.businessUnits = businessUnits;
      return this;
    }
  }
}
