package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AsAssociateArgument {
  private String businessUnitKey;

  private String associateId;

  public AsAssociateArgument() {
  }

  public AsAssociateArgument(String businessUnitKey, String associateId) {
    this.businessUnitKey = businessUnitKey;
    this.associateId = associateId;
  }

  public String getBusinessUnitKey() {
    return businessUnitKey;
  }

  public void setBusinessUnitKey(String businessUnitKey) {
    this.businessUnitKey = businessUnitKey;
  }

  public String getAssociateId() {
    return associateId;
  }

  public void setAssociateId(String associateId) {
    this.associateId = associateId;
  }

  @Override
  public String toString() {
    return "AsAssociateArgument{businessUnitKey='" + businessUnitKey + "', associateId='" + associateId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsAssociateArgument that = (AsAssociateArgument) o;
    return Objects.equals(businessUnitKey, that.businessUnitKey) &&
        Objects.equals(associateId, that.associateId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessUnitKey, associateId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String businessUnitKey;

    private String associateId;

    public AsAssociateArgument build() {
      AsAssociateArgument result = new AsAssociateArgument();
      result.businessUnitKey = this.businessUnitKey;
      result.associateId = this.associateId;
      return result;
    }

    public Builder businessUnitKey(String businessUnitKey) {
      this.businessUnitKey = businessUnitKey;
      return this;
    }

    public Builder associateId(String associateId) {
      this.associateId = associateId;
      return this;
    }
  }
}
