package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class AssetDraftInput {
  private String key;

  private List<LocalizedStringItemInputType> name;

  private List<LocalizedStringItemInputType> description;

  private CustomFieldsDraft custom;

  private List<AssetSourceInput> sources;

  private List<String> tags;

  private ResourceIdentifierInput type;

  public AssetDraftInput() {
  }

  public AssetDraftInput(String key, List<LocalizedStringItemInputType> name,
      List<LocalizedStringItemInputType> description, CustomFieldsDraft custom,
      List<AssetSourceInput> sources, List<String> tags, ResourceIdentifierInput type) {
    this.key = key;
    this.name = name;
    this.description = description;
    this.custom = custom;
    this.sources = sources;
    this.tags = tags;
    this.type = type;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public List<AssetSourceInput> getSources() {
    return sources;
  }

  public void setSources(List<AssetSourceInput> sources) {
    this.sources = sources;
  }

  public List<String> getTags() {
    return tags;
  }

  public void setTags(List<String> tags) {
    this.tags = tags;
  }

  public ResourceIdentifierInput getType() {
    return type;
  }

  public void setType(ResourceIdentifierInput type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AssetDraftInput{key='" + key + "', name='" + name + "', description='" + description + "', custom='" + custom + "', sources='" + sources + "', tags='" + tags + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssetDraftInput that = (AssetDraftInput) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(sources, that.sources) &&
        Objects.equals(tags, that.tags) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, description, custom, sources, tags, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private List<LocalizedStringItemInputType> name;

    private List<LocalizedStringItemInputType> description;

    private CustomFieldsDraft custom;

    private List<AssetSourceInput> sources;

    private List<String> tags;

    private ResourceIdentifierInput type;

    public AssetDraftInput build() {
      AssetDraftInput result = new AssetDraftInput();
      result.key = this.key;
      result.name = this.name;
      result.description = this.description;
      result.custom = this.custom;
      result.sources = this.sources;
      result.tags = this.tags;
      result.type = this.type;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder sources(List<AssetSourceInput> sources) {
      this.sources = sources;
      return this;
    }

    public Builder tags(List<String> tags) {
      this.tags = tags;
      return this;
    }

    public Builder type(ResourceIdentifierInput type) {
      this.type = type;
      return this;
    }
  }
}
