package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class AssociateDraft {
  private ResourceIdentifierInput customer;

  private List<AssociateRoleAssignmentDraft> associateRoleAssignments;

  public AssociateDraft() {
  }

  public AssociateDraft(ResourceIdentifierInput customer,
      List<AssociateRoleAssignmentDraft> associateRoleAssignments) {
    this.customer = customer;
    this.associateRoleAssignments = associateRoleAssignments;
  }

  public ResourceIdentifierInput getCustomer() {
    return customer;
  }

  public void setCustomer(ResourceIdentifierInput customer) {
    this.customer = customer;
  }

  public List<AssociateRoleAssignmentDraft> getAssociateRoleAssignments() {
    return associateRoleAssignments;
  }

  public void setAssociateRoleAssignments(
      List<AssociateRoleAssignmentDraft> associateRoleAssignments) {
    this.associateRoleAssignments = associateRoleAssignments;
  }

  @Override
  public String toString() {
    return "AssociateDraft{customer='" + customer + "', associateRoleAssignments='" + associateRoleAssignments + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssociateDraft that = (AssociateDraft) o;
    return Objects.equals(customer, that.customer) &&
        Objects.equals(associateRoleAssignments, that.associateRoleAssignments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer, associateRoleAssignments);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput customer;

    private List<AssociateRoleAssignmentDraft> associateRoleAssignments;

    public AssociateDraft build() {
      AssociateDraft result = new AssociateDraft();
      result.customer = this.customer;
      result.associateRoleAssignments = this.associateRoleAssignments;
      return result;
    }

    public Builder customer(ResourceIdentifierInput customer) {
      this.customer = customer;
      return this;
    }

    public Builder associateRoleAssignments(
        List<AssociateRoleAssignmentDraft> associateRoleAssignments) {
      this.associateRoleAssignments = associateRoleAssignments;
      return this;
    }
  }
}
