package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AssociateRoleAssignment {
  private KeyReference associateRoleRef;

  private AssociateRole associateRole;

  private AssociateInheritanceMode inheritance;

  public AssociateRoleAssignment() {
  }

  public AssociateRoleAssignment(KeyReference associateRoleRef, AssociateRole associateRole,
      AssociateInheritanceMode inheritance) {
    this.associateRoleRef = associateRoleRef;
    this.associateRole = associateRole;
    this.inheritance = inheritance;
  }

  public KeyReference getAssociateRoleRef() {
    return associateRoleRef;
  }

  public void setAssociateRoleRef(KeyReference associateRoleRef) {
    this.associateRoleRef = associateRoleRef;
  }

  public AssociateRole getAssociateRole() {
    return associateRole;
  }

  public void setAssociateRole(AssociateRole associateRole) {
    this.associateRole = associateRole;
  }

  public AssociateInheritanceMode getInheritance() {
    return inheritance;
  }

  public void setInheritance(AssociateInheritanceMode inheritance) {
    this.inheritance = inheritance;
  }

  @Override
  public String toString() {
    return "AssociateRoleAssignment{associateRoleRef='" + associateRoleRef + "', associateRole='" + associateRole + "', inheritance='" + inheritance + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssociateRoleAssignment that = (AssociateRoleAssignment) o;
    return Objects.equals(associateRoleRef, that.associateRoleRef) &&
        Objects.equals(associateRole, that.associateRole) &&
        Objects.equals(inheritance, that.inheritance);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateRoleRef, associateRole, inheritance);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private KeyReference associateRoleRef;

    private AssociateRole associateRole;

    private AssociateInheritanceMode inheritance;

    public AssociateRoleAssignment build() {
      AssociateRoleAssignment result = new AssociateRoleAssignment();
      result.associateRoleRef = this.associateRoleRef;
      result.associateRole = this.associateRole;
      result.inheritance = this.inheritance;
      return result;
    }

    public Builder associateRoleRef(KeyReference associateRoleRef) {
      this.associateRoleRef = associateRoleRef;
      return this;
    }

    public Builder associateRole(AssociateRole associateRole) {
      this.associateRole = associateRole;
      return this;
    }

    public Builder inheritance(AssociateInheritanceMode inheritance) {
      this.inheritance = inheritance;
      return this;
    }
  }
}
