package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class AssociateRolePermissionRemoved implements com.commercetools.graphql.api.types.MessagePayload {
  private Permission permission;

  private String type;

  public AssociateRolePermissionRemoved() {
  }

  public AssociateRolePermissionRemoved(Permission permission, String type) {
    this.permission = permission;
    this.type = type;
  }

  public Permission getPermission() {
    return permission;
  }

  public void setPermission(Permission permission) {
    this.permission = permission;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "AssociateRolePermissionRemoved{permission='" + permission + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AssociateRolePermissionRemoved that = (AssociateRolePermissionRemoved) o;
    return Objects.equals(permission, that.permission) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(permission, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Permission permission;

    private String type;

    public AssociateRolePermissionRemoved build() {
      AssociateRolePermissionRemoved result = new AssociateRolePermissionRemoved();
      result.permission = this.permission;
      result.type = this.type;
      return result;
    }

    public Builder permission(Permission permission) {
      this.permission = permission;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
