package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class AttributeDefinitionResult {
  private Integer limit;

  private Integer offset;

  private Integer total;

  private List<AttributeDefinition> results;

  public AttributeDefinitionResult() {
  }

  public AttributeDefinitionResult(Integer limit, Integer offset, Integer total,
      List<AttributeDefinition> results) {
    this.limit = limit;
    this.offset = offset;
    this.total = total;
    this.results = results;
  }

  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public Integer getOffset() {
    return offset;
  }

  public void setOffset(Integer offset) {
    this.offset = offset;
  }

  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  public List<AttributeDefinition> getResults() {
    return results;
  }

  public void setResults(List<AttributeDefinition> results) {
    this.results = results;
  }

  @Override
  public String toString() {
    return "AttributeDefinitionResult{limit='" + limit + "', offset='" + offset + "', total='" + total + "', results='" + results + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AttributeDefinitionResult that = (AttributeDefinitionResult) o;
    return Objects.equals(limit, that.limit) &&
        Objects.equals(offset, that.offset) &&
        Objects.equals(total, that.total) &&
        Objects.equals(results, that.results);
  }

  @Override
  public int hashCode() {
    return Objects.hash(limit, offset, total, results);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer limit;

    private Integer offset;

    private Integer total;

    private List<AttributeDefinition> results;

    public AttributeDefinitionResult build() {
      AttributeDefinitionResult result = new AttributeDefinitionResult();
      result.limit = this.limit;
      result.offset = this.offset;
      result.total = this.total;
      result.results = this.results;
      return result;
    }

    public Builder limit(Integer limit) {
      this.limit = limit;
      return this;
    }

    public Builder offset(Integer offset) {
      this.offset = offset;
      return this;
    }

    public Builder total(Integer total) {
      this.total = total;
      return this;
    }

    public Builder results(List<AttributeDefinition> results) {
      this.results = results;
      return this;
    }
  }
}
