package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class AttributeTypeDraft {
  private AttributeSetTypeDraft set;

  private SimpleAttributeTypeDraft text;

  private SimpleAttributeTypeDraft number;

  private SimpleAttributeTypeDraft money;

  private SimpleAttributeTypeDraft date;

  private SimpleAttributeTypeDraft time;

  private SimpleAttributeTypeDraft datetime;

  private SimpleAttributeTypeDraft _boolean;

  private ReferenceTypeDefinitionDraft reference;

  private EnumTypeDraft _enum;

  private LocalizableEnumTypeDraft lenum;

  private SimpleAttributeTypeDraft ltext;

  public AttributeTypeDraft() {
  }

  public AttributeTypeDraft(AttributeSetTypeDraft set, SimpleAttributeTypeDraft text,
      SimpleAttributeTypeDraft number, SimpleAttributeTypeDraft money,
      SimpleAttributeTypeDraft date, SimpleAttributeTypeDraft time,
      SimpleAttributeTypeDraft datetime, SimpleAttributeTypeDraft _boolean,
      ReferenceTypeDefinitionDraft reference, EnumTypeDraft _enum, LocalizableEnumTypeDraft lenum,
      SimpleAttributeTypeDraft ltext) {
    this.set = set;
    this.text = text;
    this.number = number;
    this.money = money;
    this.date = date;
    this.time = time;
    this.datetime = datetime;
    this._boolean = _boolean;
    this.reference = reference;
    this._enum = _enum;
    this.lenum = lenum;
    this.ltext = ltext;
  }

  public AttributeSetTypeDraft getSet() {
    return set;
  }

  public void setSet(AttributeSetTypeDraft set) {
    this.set = set;
  }

  public SimpleAttributeTypeDraft getText() {
    return text;
  }

  public void setText(SimpleAttributeTypeDraft text) {
    this.text = text;
  }

  public SimpleAttributeTypeDraft getNumber() {
    return number;
  }

  public void setNumber(SimpleAttributeTypeDraft number) {
    this.number = number;
  }

  public SimpleAttributeTypeDraft getMoney() {
    return money;
  }

  public void setMoney(SimpleAttributeTypeDraft money) {
    this.money = money;
  }

  public SimpleAttributeTypeDraft getDate() {
    return date;
  }

  public void setDate(SimpleAttributeTypeDraft date) {
    this.date = date;
  }

  public SimpleAttributeTypeDraft getTime() {
    return time;
  }

  public void setTime(SimpleAttributeTypeDraft time) {
    this.time = time;
  }

  public SimpleAttributeTypeDraft getDatetime() {
    return datetime;
  }

  public void setDatetime(SimpleAttributeTypeDraft datetime) {
    this.datetime = datetime;
  }

  public SimpleAttributeTypeDraft getBoolean() {
    return _boolean;
  }

  public void setBoolean(SimpleAttributeTypeDraft _boolean) {
    this._boolean = _boolean;
  }

  public ReferenceTypeDefinitionDraft getReference() {
    return reference;
  }

  public void setReference(ReferenceTypeDefinitionDraft reference) {
    this.reference = reference;
  }

  public EnumTypeDraft getEnum() {
    return _enum;
  }

  public void setEnum(EnumTypeDraft _enum) {
    this._enum = _enum;
  }

  public LocalizableEnumTypeDraft getLenum() {
    return lenum;
  }

  public void setLenum(LocalizableEnumTypeDraft lenum) {
    this.lenum = lenum;
  }

  public SimpleAttributeTypeDraft getLtext() {
    return ltext;
  }

  public void setLtext(SimpleAttributeTypeDraft ltext) {
    this.ltext = ltext;
  }

  @Override
  public String toString() {
    return "AttributeTypeDraft{set='" + set + "', text='" + text + "', number='" + number + "', money='" + money + "', date='" + date + "', time='" + time + "', datetime='" + datetime + "', boolean='" + _boolean + "', reference='" + reference + "', enum='" + _enum + "', lenum='" + lenum + "', ltext='" + ltext + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AttributeTypeDraft that = (AttributeTypeDraft) o;
    return Objects.equals(set, that.set) &&
        Objects.equals(text, that.text) &&
        Objects.equals(number, that.number) &&
        Objects.equals(money, that.money) &&
        Objects.equals(date, that.date) &&
        Objects.equals(time, that.time) &&
        Objects.equals(datetime, that.datetime) &&
        Objects.equals(_boolean, that._boolean) &&
        Objects.equals(reference, that.reference) &&
        Objects.equals(_enum, that._enum) &&
        Objects.equals(lenum, that.lenum) &&
        Objects.equals(ltext, that.ltext);
  }

  @Override
  public int hashCode() {
    return Objects.hash(set, text, number, money, date, time, datetime, _boolean, reference, _enum, lenum, ltext);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AttributeSetTypeDraft set;

    private SimpleAttributeTypeDraft text;

    private SimpleAttributeTypeDraft number;

    private SimpleAttributeTypeDraft money;

    private SimpleAttributeTypeDraft date;

    private SimpleAttributeTypeDraft time;

    private SimpleAttributeTypeDraft datetime;

    private SimpleAttributeTypeDraft _boolean;

    private ReferenceTypeDefinitionDraft reference;

    private EnumTypeDraft _enum;

    private LocalizableEnumTypeDraft lenum;

    private SimpleAttributeTypeDraft ltext;

    public AttributeTypeDraft build() {
      AttributeTypeDraft result = new AttributeTypeDraft();
      result.set = this.set;
      result.text = this.text;
      result.number = this.number;
      result.money = this.money;
      result.date = this.date;
      result.time = this.time;
      result.datetime = this.datetime;
      result._boolean = this._boolean;
      result.reference = this.reference;
      result._enum = this._enum;
      result.lenum = this.lenum;
      result.ltext = this.ltext;
      return result;
    }

    public Builder set(AttributeSetTypeDraft set) {
      this.set = set;
      return this;
    }

    public Builder text(SimpleAttributeTypeDraft text) {
      this.text = text;
      return this;
    }

    public Builder number(SimpleAttributeTypeDraft number) {
      this.number = number;
      return this;
    }

    public Builder money(SimpleAttributeTypeDraft money) {
      this.money = money;
      return this;
    }

    public Builder date(SimpleAttributeTypeDraft date) {
      this.date = date;
      return this;
    }

    public Builder time(SimpleAttributeTypeDraft time) {
      this.time = time;
      return this;
    }

    public Builder datetime(SimpleAttributeTypeDraft datetime) {
      this.datetime = datetime;
      return this;
    }

    public Builder _boolean(SimpleAttributeTypeDraft _boolean) {
      this._boolean = _boolean;
      return this;
    }

    public Builder reference(ReferenceTypeDefinitionDraft reference) {
      this.reference = reference;
      return this;
    }

    public Builder _enum(EnumTypeDraft _enum) {
      this._enum = _enum;
      return this;
    }

    public Builder lenum(LocalizableEnumTypeDraft lenum) {
      this.lenum = lenum;
      return this;
    }

    public Builder ltext(SimpleAttributeTypeDraft ltext) {
      this.ltext = ltext;
      return this;
    }
  }
}
